/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.annotation.ActionController;
import com.iohao.game.action.skeleton.annotation.DocActionSends;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.BarSkeletonBuilder;
import com.iohao.game.action.skeleton.core.DevConfig;
import com.iohao.game.action.skeleton.core.enhance.BarSkeletonBuilderEnhances;
import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.core.exception.MsgExceptionInfo;
import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.common.kit.ClassScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class BarSkeletonBuilderParamConfig {
    private final List<Class<?>> actionControllerClassList = new ArrayList();
    private final List<Class<?>> actionSendClassList = new ArrayList();
    private final List<MsgExceptionInfo> msgExceptionInfoList = new ArrayList<MsgExceptionInfo>();
    private boolean broadcastLog;
    private Predicate<Class<?>> actionControllerPredicate = clazz -> Objects.nonNull(clazz.getAnnotation(ActionController.class));
    private Predicate<Class<?>> actionSendPredicate = clazz -> Objects.nonNull(clazz.getAnnotation(DocActionSends.class));
    private boolean enhance = true;

    public BarSkeletonBuilder createBuilder() {
        this.addErrorCode(ActionErrorEnum.values());
        BarSkeletonBuilder builder = BarSkeleton.newBuilder();
        this.enhance(builder);
        this.scanClassActionSend(builder::addActionSend);
        this.scanClassActionController(builder::addActionController);
        this.getMsgExceptionInfoList().forEach(builder::addMsgExceptionInfo);
        DevConfig.broadcastLog = this.broadcastLog;
        BarSkeletonBuilderParamConfig.extracted();
        return builder;
    }

    public BarSkeletonBuilderParamConfig scanActionPackage(Class<?> actionControllerClass) {
        this.actionControllerClassList.add(actionControllerClass);
        return this;
    }

    public BarSkeletonBuilderParamConfig scanActionSendPackage(Class<?> actionSendClass) {
        this.actionSendClassList.add(actionSendClass);
        return this;
    }

    public BarSkeletonBuilderParamConfig addErrorCode(MsgExceptionInfo[] msgExceptionInfoArray) {
        this.msgExceptionInfoList.addAll(Arrays.asList(msgExceptionInfoArray));
        return this;
    }

    private void enhance(BarSkeletonBuilder builder) {
        if (this.enhance) {
            BarSkeletonBuilderEnhances.enhance(builder);
        }
    }

    private void scanClassActionController(Consumer<Class<?>> actionConsumer) {
        this.scanClass(this.actionControllerClassList, this.actionControllerPredicate, actionConsumer);
    }

    private void scanClassActionSend(Consumer<Class<?>> sendConsumer) {
        this.scanClass(this.actionSendClassList, this.actionSendPredicate, sendConsumer);
    }

    private void scanClass(List<Class<?>> actionList, Predicate<Class<?>> predicateFilter, Consumer<Class<?>> actionConsumer) {
        for (Class<?> actionClazz : actionList) {
            String packagePath = actionClazz.getPackageName();
            ClassScanner classScanner = new ClassScanner(packagePath, predicateFilter);
            List classList = classScanner.listScan();
            classList.forEach(actionConsumer);
        }
    }

    private static void extracted() {
        if (!Objects.equals(IoGameBanner.flag21, "ioGame21")) {
            System.out.println("http://game.iohao.com");
        }
    }

    public BarSkeletonBuilderParamConfig setBroadcastLog(boolean broadcastLog) {
        this.broadcastLog = broadcastLog;
        return this;
    }

    public BarSkeletonBuilderParamConfig setActionControllerPredicate(Predicate<Class<?>> actionControllerPredicate) {
        this.actionControllerPredicate = actionControllerPredicate;
        return this;
    }

    public BarSkeletonBuilderParamConfig setActionSendPredicate(Predicate<Class<?>> actionSendPredicate) {
        this.actionSendPredicate = actionSendPredicate;
        return this;
    }

    public BarSkeletonBuilderParamConfig setEnhance(boolean enhance) {
        this.enhance = enhance;
        return this;
    }

    public List<Class<?>> getActionControllerClassList() {
        return this.actionControllerClassList;
    }

    public List<Class<?>> getActionSendClassList() {
        return this.actionSendClassList;
    }

    public List<MsgExceptionInfo> getMsgExceptionInfoList() {
        return this.msgExceptionInfoList;
    }

    public boolean isBroadcastLog() {
        return this.broadcastLog;
    }

    public Predicate<Class<?>> getActionControllerPredicate() {
        return this.actionControllerPredicate;
    }

    public Predicate<Class<?>> getActionSendPredicate() {
        return this.actionSendPredicate;
    }

    public boolean isEnhance() {
        return this.enhance;
    }
}

