/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.core.ActionCommandHandler;
import com.iohao.game.action.skeleton.core.ActionCommandParser;
import com.iohao.game.action.skeleton.core.ActionCommandRegions;
import com.iohao.game.action.skeleton.core.ActionFactoryBean;
import com.iohao.game.action.skeleton.core.ActionParserListeners;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.BarSkeletonSetting;
import com.iohao.game.action.skeleton.core.DefaultActionFactoryBean;
import com.iohao.game.action.skeleton.core.Handler;
import com.iohao.game.action.skeleton.core.InOutManager;
import com.iohao.game.action.skeleton.core.PrintActionKit;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserListener;
import com.iohao.game.action.skeleton.core.doc.ActionSendDoc;
import com.iohao.game.action.skeleton.core.doc.ActionSendDocs;
import com.iohao.game.action.skeleton.core.doc.BarSkeletonDoc;
import com.iohao.game.action.skeleton.core.doc.BroadcastDocBuilder;
import com.iohao.game.action.skeleton.core.doc.ErrorCodeDocs;
import com.iohao.game.action.skeleton.core.exception.MsgExceptionInfo;
import com.iohao.game.action.skeleton.core.flow.ActionAfter;
import com.iohao.game.action.skeleton.core.flow.ActionMethodExceptionProcess;
import com.iohao.game.action.skeleton.core.flow.ActionMethodInOut;
import com.iohao.game.action.skeleton.core.flow.ActionMethodInvoke;
import com.iohao.game.action.skeleton.core.flow.ActionMethodParamParser;
import com.iohao.game.action.skeleton.core.flow.ActionMethodResultWrap;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.FlowContextFactory;
import com.iohao.game.action.skeleton.core.flow.ResponseMessageCreate;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultActionAfter;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultActionMethodExceptionProcess;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultActionMethodInvoke;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultActionMethodParamParser;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultActionMethodResultWrap;
import com.iohao.game.action.skeleton.core.flow.internal.DefaultResponseMessageCreate;
import com.iohao.game.action.skeleton.core.runner.Runner;
import com.iohao.game.action.skeleton.core.runner.Runners;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegion;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class BarSkeletonBuilder {
    final BarSkeletonSetting setting = new BarSkeletonSetting();
    final Runners runners = new Runners();
    final List<Handler> handlerList = new LinkedList<Handler>();
    final List<ActionMethodInOut> inOutList = new LinkedList<ActionMethodInOut>();
    final List<Class<?>> actionControllerClazzList = new LinkedList();
    final List<Class<?>> actionSendClazzList = new LinkedList();
    final List<MsgExceptionInfo> msgExceptionInfoList = new ArrayList<MsgExceptionInfo>();
    final ActionSendDocs actionSendDocs = new ActionSendDocs();
    final ErrorCodeDocs errorCodeDocs = new ErrorCodeDocs();
    ActionParserListeners actionParserListeners = new ActionParserListeners();
    ActionFactoryBean<Object> actionFactoryBean = new DefaultActionFactoryBean<Object>();
    ActionAfter actionAfter = new DefaultActionAfter();
    ActionMethodResultWrap actionMethodResultWrap = new DefaultActionMethodResultWrap();
    ActionMethodExceptionProcess actionMethodExceptionProcess = new DefaultActionMethodExceptionProcess();
    ActionMethodInvoke actionMethodInvoke = new DefaultActionMethodInvoke();
    ActionMethodParamParser actionMethodParamParser = new DefaultActionMethodParamParser();
    ResponseMessageCreate responseMessageCreate = new DefaultResponseMessageCreate();
    FlowContextFactory flowContextFactory = FlowContext::new;
    ExecutorRegion executorRegion;

    BarSkeletonBuilder() {
    }

    public BarSkeleton build() {
        this.defaultSetting();
        Handler[] handlers = new Handler[this.handlerList.size()];
        this.handlerList.toArray(handlers);
        BarSkeleton barSkeleton = new BarSkeleton(handlers).setActionFactoryBean(this.actionFactoryBean).setActionMethodInvoke(this.actionMethodInvoke).setActionMethodParamParser(this.actionMethodParamParser).setActionMethodExceptionProcess(this.actionMethodExceptionProcess).setActionMethodResultWrap(this.actionMethodResultWrap).setActionAfter(this.actionAfter).setResponseMessageCreate(this.responseMessageCreate).setActionSendDocs(this.actionSendDocs).setErrorCodeDocs(this.errorCodeDocs).setFlowContextFactory(this.flowContextFactory).setExecutorRegion(this.executorRegion).setRunners(this.runners);
        this.actionSendDocs.buildActionSendDoc(this.actionSendClazzList);
        this.extractedInOut(barSkeleton);
        this.extractedActionCommand(barSkeleton);
        PrintActionKit.print(barSkeleton, this.setting);
        BarSkeletonDoc.me().addSkeleton(barSkeleton);
        BarSkeletonDoc.me().setGenerateDoc(this.setting.generateDoc);
        this.runners.setBarSkeleton(barSkeleton);
        this.actionParserListeners = null;
        return barSkeleton;
    }

    public BarSkeletonBuilder addMsgExceptionInfo(MsgExceptionInfo msgExceptionInfo) {
        Objects.requireNonNull(msgExceptionInfo);
        this.errorCodeDocs.addMsgExceptionInfo(msgExceptionInfo);
        return this;
    }

    public BarSkeletonBuilder addActionController(Class<?> controller) {
        Objects.requireNonNull(controller);
        this.actionControllerClazzList.add(controller);
        return this;
    }

    public BarSkeletonBuilder addActionSend(Class<?> actionSend) {
        Objects.requireNonNull(actionSend);
        this.actionSendClazzList.add(actionSend);
        return this;
    }

    public BarSkeletonBuilder addActionSendDoc(ActionSendDoc actionSendDoc) {
        this.actionSendDocs.add(actionSendDoc);
        return this;
    }

    public BarSkeletonBuilder addBroadcastDoc(BroadcastDocBuilder broadcastDocBuilder) {
        return this.addActionSendDoc(broadcastDocBuilder.build());
    }

    public BarSkeletonBuilder addHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.handlerList.add(handler);
        return this;
    }

    public BarSkeletonBuilder addInOut(ActionMethodInOut inOut) {
        Objects.requireNonNull(inOut);
        this.inOutList.add(inOut);
        return this;
    }

    public BarSkeletonBuilder addRunner(Runner runner) {
        this.runners.addRunner(runner);
        return this;
    }

    public BarSkeletonBuilder addActionParserListener(ActionParserListener listener) {
        this.actionParserListeners.addActionParserListener(listener);
        return this;
    }

    private void extractedInOut(BarSkeleton barSkeleton) {
        InOutManager inOutManager = new InOutManager(this.setting, this.inOutList);
        barSkeleton.setInOutManager(inOutManager);
    }

    private void extractedActionCommand(BarSkeleton barSkeleton) {
        ActionCommandParser actionCommandParser = new ActionCommandParser(this).setBarSkeleton(barSkeleton).buildAction(this.actionControllerClazzList);
        ActionCommandRegions actionCommandRegions = actionCommandParser.getActionCommandRegions();
        barSkeleton.setActionCommandRegions(actionCommandRegions);
    }

    private void defaultSetting() {
        if (this.handlerList.isEmpty()) {
            this.handlerList.add(new ActionCommandHandler());
        }
        if (Objects.isNull(this.executorRegion)) {
            this.executorRegion = ExecutorRegionKit.createExecutorRegion();
        }
    }

    public BarSkeletonBuilder setActionParserListeners(ActionParserListeners actionParserListeners) {
        this.actionParserListeners = actionParserListeners;
        return this;
    }

    public BarSkeletonBuilder setActionFactoryBean(ActionFactoryBean<Object> actionFactoryBean) {
        this.actionFactoryBean = actionFactoryBean;
        return this;
    }

    public BarSkeletonBuilder setActionAfter(ActionAfter actionAfter) {
        this.actionAfter = actionAfter;
        return this;
    }

    public BarSkeletonBuilder setActionMethodResultWrap(ActionMethodResultWrap actionMethodResultWrap) {
        this.actionMethodResultWrap = actionMethodResultWrap;
        return this;
    }

    public BarSkeletonBuilder setActionMethodExceptionProcess(ActionMethodExceptionProcess actionMethodExceptionProcess) {
        this.actionMethodExceptionProcess = actionMethodExceptionProcess;
        return this;
    }

    public BarSkeletonBuilder setActionMethodInvoke(ActionMethodInvoke actionMethodInvoke) {
        this.actionMethodInvoke = actionMethodInvoke;
        return this;
    }

    public BarSkeletonBuilder setActionMethodParamParser(ActionMethodParamParser actionMethodParamParser) {
        this.actionMethodParamParser = actionMethodParamParser;
        return this;
    }

    public BarSkeletonBuilder setResponseMessageCreate(ResponseMessageCreate responseMessageCreate) {
        this.responseMessageCreate = responseMessageCreate;
        return this;
    }

    public BarSkeletonBuilder setFlowContextFactory(FlowContextFactory flowContextFactory) {
        this.flowContextFactory = flowContextFactory;
        return this;
    }

    public BarSkeletonBuilder setExecutorRegion(ExecutorRegion executorRegion) {
        this.executorRegion = executorRegion;
        return this;
    }

    public BarSkeletonSetting getSetting() {
        return this.setting;
    }
}

