/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserContext;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserListener;
import com.iohao.game.action.skeleton.core.action.parser.ProtobufActionParserListener;
import com.iohao.game.action.skeleton.core.action.parser.ProtobufCheckActionParserListener;
import com.iohao.game.action.skeleton.core.codec.ProtoDataCodec;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class ActionParserListeners {
    private final List<ActionParserListener> listeners = new CopyOnWriteArrayList<ActionParserListener>();

    void addActionParserListener(ActionParserListener listener) {
        this.listeners.add(listener);
    }

    void onActionCommand(ActionParserContext context) {
        this.listeners.forEach(listener -> listener.onActionCommand(context));
    }

    void onAfter(BarSkeleton barSkeleton) {
        this.listeners.forEach(listener -> listener.onAfter(barSkeleton));
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public ActionParserListeners() {
        if (DataCodecKit.getDataCodec() instanceof ProtoDataCodec) {
            this.addActionParserListener(ProtobufActionParserListener.me());
            this.addActionParserListener(ProtobufCheckActionParserListener.me());
        }
    }
}

