/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.ActionCommandRegion;
import com.iohao.game.action.skeleton.core.BarSkeletonSetting;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.common.kit.MoreKit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public final class ActionCommandRegions {
    private static final ActionCommand[][] EMPTY = new ActionCommand[0][0];
    final Map<Integer, ActionCommandRegion> regionMap = new NonBlockingHashMap();
    ActionCommand[][] actionCommands = EMPTY;

    public ActionCommand getActionCommand(int cmd, int subCmd) {
        if (cmd >= this.actionCommands.length) {
            return null;
        }
        ActionCommand[] subActionCommands = this.actionCommands[cmd];
        if (subCmd >= subActionCommands.length) {
            return null;
        }
        return this.actionCommands[cmd][subCmd];
    }

    public ActionCommand getActionCommand(int cmdMerge) {
        int cmd = CmdKit.getCmd(cmdMerge);
        int subCmd = CmdKit.getSubCmd(cmdMerge);
        return this.getActionCommand(cmd, subCmd);
    }

    public List<Integer> listCmdMerge() {
        return this.regionMap.values().parallelStream().flatMap(actionCommandRegion -> actionCommandRegion.values().parallelStream()).map(ActionCommand::getCmdInfo).map(CmdInfo::getCmdMerge).collect(Collectors.toList());
    }

    Stream<ActionCommandRegion> streamActionCommandRegion() {
        return this.regionMap.values().parallelStream();
    }

    ActionCommandRegion getActionCommandRegion(int cmd) {
        ActionCommandRegion actionCommandRegion = this.regionMap.get(cmd);
        if (Objects.isNull(actionCommandRegion)) {
            ActionCommandRegion newValue = new ActionCommandRegion(cmd);
            return (ActionCommandRegion)MoreKit.putIfAbsent(this.regionMap, (Object)cmd, (Object)newValue);
        }
        return actionCommandRegion;
    }

    void initActionCommandArray(BarSkeletonSetting barSkeletonSetting) {
        this.actionCommands = this.convertArray(barSkeletonSetting);
    }

    private ActionCommand[][] convertArray(BarSkeletonSetting barSkeletonSetting) {
        if (this.regionMap.isEmpty()) {
            return EMPTY;
        }
        int max = this.getMaxCmd(barSkeletonSetting);
        ActionCommand[][] behaviors = new ActionCommand[max][1];
        this.regionMap.keySet().forEach(cmd -> {
            ActionCommandRegion actionCommandRegion = this.regionMap.get(cmd);
            behaviors[cmd.intValue()] = actionCommandRegion.arrayActionCommand();
        });
        return behaviors;
    }

    private int getMaxCmd(BarSkeletonSetting barSkeletonSetting) {
        int max = this.regionMap.keySet().stream().max(Integer::compareTo).orElse(0) + 1;
        if (max > barSkeletonSetting.getCmdMaxLen()) {
            String info = String.format("cmd \u8d85\u8fc7\u6700\u5927\u9ed8\u8ba4\u503c! \u5982\u679c\u6709\u9700\u8981, \u8bf7\u624b\u52a8\u8bbe\u7f6e\u5bb9\u91cf!  \u9ed8\u8ba4\u6700\u5927\u5bb9\u91cf %s. \u5f53\u524d\u5bb9\u91cf %s", barSkeletonSetting.getCmdMaxLen(), max);
            throw new RuntimeException(info);
        }
        for (ActionCommandRegion actionCommandRegion : this.regionMap.values()) {
            int subCmdMax = actionCommandRegion.getMaxSubCmd() + 1;
            if (subCmdMax <= barSkeletonSetting.getSubCmdMaxLen()) continue;
            String info = String.format("subCmd \u8d85\u8fc7\u6700\u5927\u9ed8\u8ba4\u503c! \u5982\u679c\u6709\u9700\u8981, \u8bf7\u624b\u52a8\u8bbe\u7f6e\u5bb9\u91cf!  \u9ed8\u8ba4\u6700\u5927\u5bb9\u91cf %s. \u5f53\u524d\u5bb9\u91cf %s", barSkeletonSetting.getSubCmdMaxLen(), subCmdMax);
            throw new RuntimeException(info);
        }
        return max;
    }

    public Map<Integer, ActionCommandRegion> getRegionMap() {
        return this.regionMap;
    }

    public ActionCommand[][] getActionCommands() {
        return this.actionCommands;
    }
}

