/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.doc.JavaClassDocInfo;
import java.util.Collection;
import java.util.Map;
import org.jctools.maps.NonBlockingHashMap;

public final class ActionCommandRegion {
    final int cmd;
    Class<?> actionControllerClazz;
    JavaClassDocInfo javaClassDocInfo;
    Map<Integer, ActionCommand> subActionCommandMap = new NonBlockingHashMap();

    public ActionCommandRegion(int cmd) {
        this.cmd = cmd;
    }

    public boolean containsKey(int subCmd) {
        return this.subActionCommandMap.containsKey(subCmd);
    }

    public void add(ActionCommand subActionCommand) {
        CmdInfo cmdInfo = subActionCommand.getCmdInfo();
        int subCmd = cmdInfo.getSubCmd();
        this.subActionCommandMap.put(subCmd, subActionCommand);
    }

    public int getMaxSubCmd() {
        return this.subActionCommandMap.keySet().stream().max(Integer::compareTo).orElse(0);
    }

    public Collection<ActionCommand> values() {
        return this.subActionCommandMap.values();
    }

    public ActionCommand[] arrayActionCommand() {
        int subCmdMax = this.getMaxSubCmd() + 1;
        ActionCommand[] subBehaviors = new ActionCommand[subCmdMax];
        for (Map.Entry<Integer, ActionCommand> subEntry : this.subActionCommandMap.entrySet()) {
            subBehaviors[subEntry.getKey().intValue()] = subEntry.getValue();
        }
        return subBehaviors;
    }

    public int getCmd() {
        return this.cmd;
    }

    public Class<?> getActionControllerClazz() {
        return this.actionControllerClazz;
    }

    public JavaClassDocInfo getJavaClassDocInfo() {
        return this.javaClassDocInfo;
    }

    public Map<Integer, ActionCommand> getSubActionCommandMap() {
        return this.subActionCommandMap;
    }

    public void setActionControllerClazz(Class<?> actionControllerClazz) {
        this.actionControllerClazz = actionControllerClazz;
    }

    public void setJavaClassDocInfo(JavaClassDocInfo javaClassDocInfo) {
        this.javaClassDocInfo = javaClassDocInfo;
    }

    public void setSubActionCommandMap(Map<Integer, ActionCommand> subActionCommandMap) {
        this.subActionCommandMap = subActionCommandMap;
    }
}

