/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.iohao.game.action.skeleton.annotation.ActionController;
import com.iohao.game.action.skeleton.annotation.ActionMethod;
import com.iohao.game.action.skeleton.core.ActionCommand;
import com.iohao.game.action.skeleton.core.ActionCommandDocParser;
import com.iohao.game.action.skeleton.core.ActionCommandRegion;
import com.iohao.game.action.skeleton.core.ActionCommandRegions;
import com.iohao.game.action.skeleton.core.ActionParserListeners;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.BarSkeletonBuilder;
import com.iohao.game.action.skeleton.core.BarSkeletonSetting;
import com.iohao.game.action.skeleton.core.DependencyInjectionPart;
import com.iohao.game.action.skeleton.core.ValidatorKit;
import com.iohao.game.action.skeleton.core.action.parser.ActionParserContext;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.doc.ActionDoc;
import com.iohao.game.action.skeleton.core.doc.ActionDocs;
import com.iohao.game.common.kit.StrKit;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

final class ActionCommandParser {
    private final ActionCommandRegions actionCommandRegions = new ActionCommandRegions();
    private final BarSkeletonSetting setting;
    private final ActionParserListeners actionParserListeners;
    private BarSkeleton barSkeleton;

    ActionCommandParser(BarSkeletonBuilder builder) {
        this.setting = builder.getSetting();
        this.actionParserListeners = builder.actionParserListeners;
    }

    ActionCommandParser buildAction(List<Class<?>> controllerList) {
        ActionCommandDocParser doc = new ActionCommandDocParser(this, controllerList, this.setting.parseDoc);
        this.getActionControllerStream(controllerList).forEach(controllerClazz -> {
            MethodAccess methodAccess = MethodAccess.get((Class)controllerClazz);
            ConstructorAccess constructorAccess = ConstructorAccess.get((Class)controllerClazz);
            int cmd = controllerClazz.getAnnotation(ActionController.class).value();
            ActionCommandRegion actionCommandRegion = this.actionCommandRegions.getActionCommandRegion(cmd);
            actionCommandRegion.setActionControllerClazz((Class<?>)controllerClazz);
            boolean deliveryContainer = this.deliveryContainer((Class<?>)controllerClazz);
            Object actionControllerInstance = this.ofActionInstance((Class<?>)controllerClazz);
            this.getMethodStream((Class<?>)controllerClazz).forEach(method -> {
                int subCmd = method.getAnnotation(ActionMethod.class).value();
                String methodName = method.getName();
                int methodIndex = methodAccess.getIndex(methodName);
                Class returnType = methodAccess.getReturnTypes()[methodIndex];
                ActionCommandDoc actionCommandDoc = doc.getActionCommandDoc(cmd, subCmd);
                ActionCommand.Builder builder = new ActionCommand.Builder().setCmd(cmd).setSubCmd(subCmd).setActionControllerClazz((Class<?>)controllerClazz).setActionControllerConstructorAccess(constructorAccess).setActionMethod((Method)method).setActionMethodName(methodName).setActionMethodIndex(methodIndex).setActionMethodAccess(methodAccess).setReturnTypeClazz(returnType).setActionCommandDoc(actionCommandDoc).setDeliveryContainer(deliveryContainer).setCreateSingleActionCommandController(this.setting.createSingleActionCommandController).setActionController(actionControllerInstance);
                this.checkExistSubCmd((Class<?>)controllerClazz, subCmd, actionCommandRegion);
                this.paramInfo((Method)method, builder);
                ActionCommand command = builder.build();
                actionCommandRegion.add(command);
                ActionDoc actionDoc = ActionDocs.ofActionDoc(cmd, controllerClazz);
                actionDoc.addActionCommand(command);
            });
        });
        this.actionCommandRegions.initActionCommandArray(this.setting);
        this.executeActionListeners();
        return this;
    }

    Stream<Class<?>> getActionControllerStream(List<Class<?>> controllerList) {
        HashSet controllerSet = new HashSet(controllerList);
        return controllerSet.stream().filter(clazz -> Objects.nonNull(clazz.getAnnotation(ActionController.class)));
    }

    Stream<Method> getMethodStream(Class<?> actionControllerClass) {
        return Arrays.stream(actionControllerClass.getDeclaredMethods()).filter(method -> Objects.nonNull(method.getAnnotation(ActionMethod.class))).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isStatic(method.getModifiers()));
    }

    private boolean deliveryContainer(Class<?> controllerClazz) {
        if (DependencyInjectionPart.me().isInjection()) {
            return DependencyInjectionPart.me().deliveryContainer(controllerClazz);
        }
        return false;
    }

    private void paramInfo(Method method, ActionCommand.Builder builder) {
        Parameter[] parameters = method.getParameters();
        if (Objects.isNull(parameters)) {
            return;
        }
        ActionCommand.ParamInfo[] paramInfos = new ActionCommand.ParamInfo[parameters.length];
        builder.setParamInfos(paramInfos);
        for (int i = 0; i < parameters.length; ++i) {
            ActionCommand.ParamInfo paramInfo;
            Parameter parameter = parameters[i];
            paramInfos[i] = paramInfo = new ActionCommand.ParamInfo(i, parameter);
            if (!this.setting.validator || paramInfo.isFlowContext()) continue;
            paramInfo.validator = ValidatorKit.isValidator(parameter.getType());
        }
    }

    private void checkExistSubCmd(Class<?> controllerClass, int subCmd, ActionCommandRegion actionCommandRegion) {
        if (actionCommandRegion.containsKey(subCmd)) {
            String message = StrKit.format((CharSequence)"cmd:\u3010{}\u3011\u4e0b\u5df2\u7ecf\u5b58\u5728\u65b9\u6cd5\u7f16\u53f7 subCmd:\u3010{}\u3011 .\u8bf7\u67e5\u770b: {}", (Object[])new Object[]{actionCommandRegion.cmd, subCmd, controllerClass});
            throw new RuntimeException(message);
        }
    }

    private Object ofActionInstance(Class<?> controllerClazz) {
        boolean deliveryContainer = this.deliveryContainer(controllerClazz);
        Object actionInstance = deliveryContainer ? DependencyInjectionPart.me().getBean(controllerClazz) : ConstructorAccess.get(controllerClazz).newInstance();
        Objects.requireNonNull(actionInstance);
        return actionInstance;
    }

    private void executeActionListeners() {
        this.actionCommandRegions.regionMap.forEach((cmd, actionCommandRegion) -> actionCommandRegion.getSubActionCommandMap().forEach((subCmd, command) -> {
            ActionParserContext context = new ActionParserContext().setBarSkeleton(this.barSkeleton).setActionCommand((ActionCommand)command);
            this.actionParserListeners.onActionCommand(context);
        }));
        this.actionParserListeners.onAfter(this.barSkeleton);
    }

    public ActionCommandParser setBarSkeleton(BarSkeleton barSkeleton) {
        this.barSkeleton = barSkeleton;
        return this;
    }

    public ActionCommandRegions getActionCommandRegions() {
        return this.actionCommandRegions;
    }
}

