/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.iohao.game.action.skeleton.annotation.ActionController;
import com.iohao.game.action.skeleton.annotation.ActionMethod;
import com.iohao.game.action.skeleton.core.ActionCommandParser;
import com.iohao.game.action.skeleton.core.ActionCommandRegion;
import com.iohao.game.action.skeleton.core.ActionCommandRegions;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDocKit;
import com.iohao.game.action.skeleton.core.doc.ActionDoc;
import com.iohao.game.action.skeleton.core.doc.ActionDocs;
import com.iohao.game.action.skeleton.core.doc.JavaClassDocInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

final class ActionCommandDocParser {
    private final ActionCommandParser actionCommandParser;
    private final Map<Integer, ActionCommandDoc> actionCommandDocMap = new NonBlockingHashMap();
    private final ActionCommandDoc emptyActionCommandDoc = new ActionCommandDoc();

    ActionCommandDocParser(ActionCommandParser actionCommandParser, List<Class<?>> controllerList, boolean parseDoc) {
        this.actionCommandParser = actionCommandParser;
        if (parseDoc) {
            this.buildSourceDoc(controllerList);
        }
    }

    private void buildSourceDoc(List<Class<?>> controllerList) {
        ActionCommandRegions actionCommandRegions = this.actionCommandParser.getActionCommandRegions();
        Map<String, JavaClassDocInfo> javaClassDocInfoMap = ActionCommandDocKit.getJavaClassDocInfoMap(controllerList);
        ((Stream)this.actionCommandParser.getActionControllerStream(controllerList).parallel()).forEach(controllerClazz -> {
            JavaClassDocInfo javaClassDocInfo = (JavaClassDocInfo)javaClassDocInfoMap.get(controllerClazz.toString());
            int cmd = controllerClazz.getAnnotation(ActionController.class).value();
            ActionCommandDocParser.extractedDeprecate(actionCommandRegions, controllerClazz, javaClassDocInfo, cmd);
            ActionDoc actionDoc = ActionDocs.ofActionDoc(cmd, controllerClazz);
            actionDoc.setJavaClassDocInfo(javaClassDocInfo);
            this.actionCommandParser.getMethodStream((Class<?>)controllerClazz).forEach(method -> {
                ActionCommandDoc actionCommandDoc = this.getActionCommandDoc(javaClassDocInfo, (Method)method);
                int subCmd = method.getAnnotation(ActionMethod.class).value();
                int cmdMerge = CmdKit.merge(cmd, subCmd);
                this.actionCommandDocMap.put(cmdMerge, actionCommandDoc);
                actionDoc.addActionCommandDoc(actionCommandDoc);
            });
        });
    }

    private static void extractedDeprecate(ActionCommandRegions actionCommandRegions, Class<?> controllerClazz, JavaClassDocInfo javaClassDocInfo, int cmd) {
        ActionCommandRegion actionCommandRegion = actionCommandRegions.getActionCommandRegion(cmd);
        actionCommandRegion.setActionControllerClazz(controllerClazz);
        actionCommandRegion.setJavaClassDocInfo(javaClassDocInfo);
    }

    ActionCommandDoc getActionCommandDoc(int cmd, int subCmd) {
        int cmdMerge = CmdKit.merge(cmd, subCmd);
        return this.actionCommandDocMap.getOrDefault(cmdMerge, this.emptyActionCommandDoc);
    }

    private ActionCommandDoc getActionCommandDoc(JavaClassDocInfo javaClassDocInfo, Method method) {
        if (javaClassDocInfo != null) {
            return javaClassDocInfo.createActionCommandDoc(method);
        }
        return new ActionCommandDoc();
    }
}

