/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.action.skeleton.core;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.iohao.game.action.skeleton.annotation.ValidatedGroup;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdInfoFlyweightFactory;
import com.iohao.game.action.skeleton.core.doc.ActionCommandDoc;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParser;
import com.iohao.game.action.skeleton.core.flow.parser.MethodParsers;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class ActionCommand {
    final CmdInfo cmdInfo;
    final ConstructorAccess<?> actionControllerConstructorAccess;
    final Object actionController;
    final Class<?> actionControllerClazz;
    final boolean createSingleActionCommandController;
    final Method actionMethod;
    final String actionMethodName;
    final int actionMethodIndex;
    final MethodAccess actionMethodAccess;
    final ParamInfo[] paramInfos;
    final boolean methodHasParam;
    final boolean throwException;
    final ActionMethodReturnInfo actionMethodReturnInfo;
    final ActionCommandDoc actionCommandDoc;
    boolean deliveryContainer;

    private ActionCommand(Builder builder) {
        this.cmdInfo = CmdInfoFlyweightFactory.of(builder.cmd, builder.subCmd);
        this.actionControllerClazz = builder.actionControllerClazz;
        this.actionControllerConstructorAccess = builder.actionControllerConstructorAccess;
        this.actionController = builder.actionController;
        this.createSingleActionCommandController = builder.createSingleActionCommandController;
        this.actionMethod = builder.actionMethod;
        this.actionMethodName = builder.actionMethodName;
        this.actionMethodIndex = builder.actionMethodIndex;
        this.actionMethodAccess = builder.actionMethodAccess;
        this.paramInfos = builder.paramInfos;
        this.methodHasParam = builder.paramInfos != null;
        this.throwException = builder.actionMethod.getExceptionTypes().length != 0;
        this.actionMethodReturnInfo = new ActionMethodReturnInfo(builder);
        this.actionCommandDoc = builder.actionCommandDoc;
        this.deliveryContainer = builder.deliveryContainer;
    }

    public Stream<ParamInfo> streamParamInfo() {
        return this.methodHasParam ? Arrays.stream(this.paramInfos) : Stream.empty();
    }

    public CmdInfo getCmdInfo() {
        return this.cmdInfo;
    }

    public ConstructorAccess<?> getActionControllerConstructorAccess() {
        return this.actionControllerConstructorAccess;
    }

    public Object getActionController() {
        return this.actionController;
    }

    public Class<?> getActionControllerClazz() {
        return this.actionControllerClazz;
    }

    public boolean isCreateSingleActionCommandController() {
        return this.createSingleActionCommandController;
    }

    public Method getActionMethod() {
        return this.actionMethod;
    }

    public String getActionMethodName() {
        return this.actionMethodName;
    }

    public int getActionMethodIndex() {
        return this.actionMethodIndex;
    }

    public MethodAccess getActionMethodAccess() {
        return this.actionMethodAccess;
    }

    public ParamInfo[] getParamInfos() {
        return this.paramInfos;
    }

    public boolean isMethodHasParam() {
        return this.methodHasParam;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public ActionMethodReturnInfo getActionMethodReturnInfo() {
        return this.actionMethodReturnInfo;
    }

    public ActionCommandDoc getActionCommandDoc() {
        return this.actionCommandDoc;
    }

    public boolean isDeliveryContainer() {
        return this.deliveryContainer;
    }

    static final class Builder {
        public int cmd;
        public int subCmd;
        public MethodAccess actionMethodAccess;
        public ConstructorAccess<?> actionControllerConstructorAccess;
        public String actionMethodName;
        public Class<?> actionControllerClazz;
        public Method actionMethod;
        public ParamInfo[] paramInfos;
        public int actionMethodIndex;
        public Class<?> returnTypeClazz;
        public ActionCommandDoc actionCommandDoc;
        public boolean deliveryContainer;
        public boolean createSingleActionCommandController;
        public Object actionController;

        Builder() {
        }

        ActionCommand build() {
            return new ActionCommand(this);
        }

        public Builder setCmd(int cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder setSubCmd(int subCmd) {
            this.subCmd = subCmd;
            return this;
        }

        public Builder setActionMethodAccess(MethodAccess actionMethodAccess) {
            this.actionMethodAccess = actionMethodAccess;
            return this;
        }

        public Builder setActionControllerConstructorAccess(ConstructorAccess<?> actionControllerConstructorAccess) {
            this.actionControllerConstructorAccess = actionControllerConstructorAccess;
            return this;
        }

        public Builder setActionMethodName(String actionMethodName) {
            this.actionMethodName = actionMethodName;
            return this;
        }

        public Builder setActionControllerClazz(Class<?> actionControllerClazz) {
            this.actionControllerClazz = actionControllerClazz;
            return this;
        }

        public Builder setActionMethod(Method actionMethod) {
            this.actionMethod = actionMethod;
            return this;
        }

        public Builder setParamInfos(ParamInfo[] paramInfos) {
            this.paramInfos = paramInfos;
            return this;
        }

        public Builder setActionMethodIndex(int actionMethodIndex) {
            this.actionMethodIndex = actionMethodIndex;
            return this;
        }

        public Builder setReturnTypeClazz(Class<?> returnTypeClazz) {
            this.returnTypeClazz = returnTypeClazz;
            return this;
        }

        public Builder setActionCommandDoc(ActionCommandDoc actionCommandDoc) {
            this.actionCommandDoc = actionCommandDoc;
            return this;
        }

        public Builder setDeliveryContainer(boolean deliveryContainer) {
            this.deliveryContainer = deliveryContainer;
            return this;
        }

        public Builder setCreateSingleActionCommandController(boolean createSingleActionCommandController) {
            this.createSingleActionCommandController = createSingleActionCommandController;
            return this;
        }

        public Builder setActionController(Object actionController) {
            this.actionController = actionController;
            return this;
        }
    }

    public static final class ParamInfo
    implements MethodParamResultInfo {
        static final Class<?>[] EMPTY_GROUPS = new Class[0];
        final String name;
        final int index;
        final Parameter parameter;
        final Class<?> paramClazz;
        final Class<?> actualTypeArgumentClazz;
        final boolean list;
        final Class<?> actualClazz;
        final boolean customMethodParser;
        final Class<?>[] validatorGroups;
        final boolean flowContext;
        boolean validator;

        ParamInfo(int index, Parameter p) {
            this.parameter = p;
            this.index = index;
            this.name = p.getName();
            this.paramClazz = p.getType();
            if (List.class.isAssignableFrom(this.paramClazz)) {
                ParameterizedType genericReturnType = (ParameterizedType)p.getParameterizedType();
                this.actualTypeArgumentClazz = (Class)genericReturnType.getActualTypeArguments()[0];
                this.list = true;
            } else {
                this.actualTypeArgumentClazz = this.paramClazz;
                this.list = false;
            }
            MethodParser methodParser = MethodParsers.getMethodParser(this);
            this.actualClazz = methodParser.getActualClazz(this);
            this.customMethodParser = methodParser.isCustomMethodParser();
            ValidatedGroup validatedAnn = this.parameter.getAnnotation(ValidatedGroup.class);
            this.validatorGroups = Objects.isNull(validatedAnn) ? EMPTY_GROUPS : validatedAnn.value();
            this.flowContext = FlowContext.class.isAssignableFrom(this.actualTypeArgumentClazz);
        }

        public boolean isBizData() {
            return !this.flowContext;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean fullName) {
            boolean isCustomList;
            boolean bl = isCustomList = this.list && !MethodParsers.containsKey(this.actualClazz);
            if (isCustomList) {
                String simpleNameParamClazz = this.paramClazz.getSimpleName();
                String simpleNameActualClazz = fullName ? this.actualClazz.getName() : this.actualClazz.getSimpleName();
                return String.format("%s<%s> %s", simpleNameParamClazz, simpleNameActualClazz, this.name);
            }
            String simpleNameActualClazz = fullName ? this.actualClazz.getName() : this.actualClazz.getSimpleName();
            return String.format("%s %s", simpleNameActualClazz, this.name);
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public Class<?> getParamClazz() {
            return this.paramClazz;
        }

        @Override
        public Class<?> getActualTypeArgumentClazz() {
            return this.actualTypeArgumentClazz;
        }

        @Override
        public boolean isList() {
            return this.list;
        }

        public Class<?> getActualClazz() {
            return this.actualClazz;
        }

        public boolean isCustomMethodParser() {
            return this.customMethodParser;
        }

        public Class<?>[] getValidatorGroups() {
            return this.validatorGroups;
        }

        public boolean isFlowContext() {
            return this.flowContext;
        }

        public boolean isValidator() {
            return this.validator;
        }
    }

    public static final class ActionMethodReturnInfo
    implements MethodParamResultInfo {
        private final Class<?> returnTypeClazz;
        private final Class<?> actualTypeArgumentClazz;
        private final boolean list;
        private final Class<?> actualClazz;
        private final boolean customMethodParser;

        private ActionMethodReturnInfo(Builder builder) {
            this.returnTypeClazz = builder.returnTypeClazz;
            if (List.class.isAssignableFrom(this.returnTypeClazz)) {
                ParameterizedType genericReturnType = (ParameterizedType)builder.actionMethod.getGenericReturnType();
                this.actualTypeArgumentClazz = (Class)genericReturnType.getActualTypeArguments()[0];
                this.list = true;
            } else {
                this.actualTypeArgumentClazz = this.returnTypeClazz;
                this.list = false;
            }
            MethodParser methodParser = MethodParsers.getMethodParser(this);
            this.actualClazz = methodParser.getActualClazz(this);
            this.customMethodParser = methodParser.isCustomMethodParser();
        }

        public boolean isVoid() {
            return Void.TYPE == this.returnTypeClazz;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean fullName) {
            boolean isCustomList;
            boolean bl = isCustomList = this.list && !MethodParsers.containsKey(this.actualClazz);
            if (isCustomList) {
                String simpleNameReturnTypeClazz = this.returnTypeClazz.getSimpleName();
                String simpleNameActualClazz = fullName ? this.actualClazz.getName() : this.actualClazz.getSimpleName();
                return String.format("%s<%s>", simpleNameReturnTypeClazz, simpleNameActualClazz);
            }
            return fullName ? this.actualClazz.getName() : this.actualClazz.getSimpleName();
        }

        public Class<?> getReturnTypeClazz() {
            return this.returnTypeClazz;
        }

        @Override
        public Class<?> getActualTypeArgumentClazz() {
            return this.actualTypeArgumentClazz;
        }

        @Override
        public boolean isList() {
            return this.list;
        }

        public Class<?> getActualClazz() {
            return this.actualClazz;
        }

        public boolean isCustomMethodParser() {
            return this.customMethodParser;
        }
    }

    public static interface MethodParamResultInfo {
        default public boolean isList() {
            return false;
        }

        public Class<?> getActualTypeArgumentClazz();
    }
}

