/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.iohao.game.bolt.broker.core.aware.BrokerClientItemAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientItem;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectEventClientProcessor
implements ConnectionEventProcessor,
BrokerClientItemAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ConnectionTopic");
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicInteger connectTimes = new AtomicInteger();
    private Connection connection;
    private String remoteAddress;
    private final CountDownLatch latch = new CountDownLatch(1);
    static final LongAdder count = new LongAdder();
    BrokerClientItem brokerClientItem;

    public void onEvent(String remoteAddress, Connection conn) {
        long connectIndex = 2L;
        ExecutorRegionKit.getSimpleThreadExecutor((long)connectIndex).executeTry(() -> this.extracted(remoteAddress, conn));
    }

    private void extracted(String remoteAddress, Connection conn) {
        if (IoGameGlobalConfig.openLog) {
            log.info("\u8fde\u63a5\u7f51\u5173 ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0cConnection:\u3010{}\u3011", new Object[]{ConnectionEventType.CONNECT, remoteAddress, conn});
        }
        this.doCheckConnection(conn);
        this.remoteAddress = remoteAddress;
        this.connection = conn;
        this.connected.set(true);
        this.connectTimes.incrementAndGet();
        this.latch.countDown();
        this.brokerClientItem.setConnection(conn);
        count.increment();
        if (IoGameGlobalConfig.openLog) {
            BrokerClient brokerClient = this.brokerClientItem.getBrokerClient();
            BrokerClientManager brokerClientManager = brokerClient.getBrokerClientManager();
            log.info("\u8fde\u63a5\u7f51\u5173 ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0c\u7f51\u5173\u8fde\u63a5\u6570\u91cf:\u3010{}\u3011", new Object[]{ConnectionEventType.CONNECT, remoteAddress, brokerClientManager.countActiveItem()});
        }
    }

    private void doCheckConnection(Connection conn) {
        Objects.requireNonNull(conn);
        Objects.requireNonNull(conn.getPoolKeys());
        Objects.requireNonNull(conn.getChannel());
        Objects.requireNonNull(conn.getUrl());
        Objects.requireNonNull((Connection)conn.getChannel().attr(Connection.CONNECTION).get());
    }

    public boolean isConnected() throws InterruptedException {
        this.latch.await();
        return this.connected.get();
    }

    public int getConnectTimes() throws InterruptedException {
        this.latch.await();
        return this.connectTimes.get();
    }

    public Connection getConnection() throws InterruptedException {
        this.latch.await();
        return this.connection;
    }

    public String getRemoteAddress() throws InterruptedException {
        this.latch.await();
        return this.remoteAddress;
    }

    public void reset() {
        this.connectTimes.set(0);
        this.connected.set(false);
        this.connection = null;
    }

    public void setBrokerClientItem(BrokerClientItem brokerClientItem) {
        this.brokerClientItem = brokerClientItem;
    }
}

