/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.BrokerClusterMessage;
import com.iohao.game.bolt.broker.core.message.BrokerMessage;
import com.iohao.game.common.kit.CollKit;
import com.iohao.game.common.kit.ExecutorKit;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerClusterMessageClientProcessor
extends AsyncUserProcessor<BrokerClusterMessage>
implements BrokerClientAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ClusterTopic");
    final ExecutorService executorService = ExecutorKit.newSingleThreadExecutor((String)"BrokerClusterMessageClientProcessor");
    BrokerClient brokerClient;

    public Executor getExecutor() {
        return this.executorService;
    }

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, BrokerClusterMessage message) {
        long clusterExecutorIndex = 2L;
        ExecutorRegionKit.getSimpleThreadExecutor((long)clusterExecutorIndex).executeTry(() -> this.extracted(message));
    }

    private void extracted(BrokerClusterMessage message) {
        List brokerMessageList = message.getBrokerMessageList();
        if (CollKit.isEmpty((Collection)brokerMessageList)) {
            return;
        }
        if (IoGameGlobalConfig.isBrokerClusterLog()) {
            System.out.println();
            log.info("==\u63a5\u6536\u6765\u81ea\u7f51\u5173\u7684\u96c6\u7fa4\u6d88\u606f {} - {} - {}", new Object[]{brokerMessageList.size(), message.getName(), message});
        }
        BrokerClientManager brokerClientManager = this.brokerClient.getBrokerClientManager();
        Set keySet = brokerClientManager.keySet();
        for (BrokerMessage brokerMessage : brokerMessageList) {
            Map brokerClientItemMap;
            String address = brokerMessage.getAddress();
            keySet.remove(address);
            if (brokerClientManager.contains(address) || (brokerClientItemMap = brokerClientManager.getBrokerClientItemMap()).containsKey(address)) continue;
            if (IoGameGlobalConfig.isBrokerClusterLog()) {
                log.info("\u96c6\u7fa4\u6709\u65b0\u7684\u673a\u5668 address : {}", (Object)address);
            }
            brokerClientManager.register(address);
        }
        for (String address : keySet) {
            if (address.contains("127.0.0.1")) continue;
            brokerClientManager.remove(address);
        }
    }

    public String interest() {
        return BrokerClusterMessage.class.getName();
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

