/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.net;

import com.intuit.ipp.exception.ConfigurationException;
import com.intuit.ipp.net.RetryHelper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.security.sasl.SaslException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class IntuitRetryPolicyHandler
implements HttpRequestRetryHandler {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final double NUM_0_8 = 0.8;
    private static final double NUM_1_2 = 1.2;
    private int retryCount;
    private int retryInterval;
    private int initialInterval;
    private int increment;
    private int minBackoff;
    private int maxBackoff;
    private int deltaBackoff;
    private String mechanism;

    public IntuitRetryPolicyHandler(int retryCount, int retryInterval) throws ConfigurationException {
        RetryHelper.argumentNotNegativeValue(retryCount, "retry.fixed.count");
        RetryHelper.argumentNotNegativeValue(retryInterval, "retry.fixed.interval");
        this.retryCount = retryCount;
        this.retryInterval = retryInterval;
        this.mechanism = "fixedretry";
    }

    public IntuitRetryPolicyHandler(int retryCount, int initialInterval, int increment) throws ConfigurationException {
        RetryHelper.argumentNotNegativeValue(retryCount, "retry.incremental.count");
        RetryHelper.argumentNotNegativeValue(initialInterval, "retry.incremental.interval");
        RetryHelper.argumentNotNegativeValue(increment, "retry.incremental.increment");
        this.retryCount = retryCount;
        this.initialInterval = initialInterval;
        this.increment = increment;
        this.mechanism = "incrementalretry";
    }

    public IntuitRetryPolicyHandler(int retryCount, int minBackoff, int maxBackoff, int deltaBackoff) throws ConfigurationException {
        RetryHelper.argumentNotNegativeValue(retryCount, "retry.exponential.count");
        RetryHelper.argumentNotNegativeValue(minBackoff, "retry.exponential.minBackoff");
        RetryHelper.argumentNotNegativeValue(maxBackoff, "retry.exponential.maxBackoff");
        RetryHelper.argumentNotNegativeValue(deltaBackoff, "retry.exponential.deltaBackoff");
        this.retryCount = retryCount;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.deltaBackoff = deltaBackoff;
        this.mechanism = "exponentialretry";
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean sent;
        boolean idempotent;
        LOG.debug("In retry request");
        if (exception == null) {
            throw new IllegalArgumentException("Exception parameter may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        if (executionCount > this.retryCount) {
            return this.checkPolicy(executionCount);
        }
        if (exception instanceof NoHttpResponseException) {
            return this.checkPolicy(executionCount);
        }
        if (exception instanceof InterruptedIOException) {
            return false;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (exception instanceof ConnectException) {
            return false;
        }
        if (exception instanceof SSLException) {
            return false;
        }
        if (exception instanceof ProtocolException) {
            return false;
        }
        if (exception instanceof SaslException) {
            return false;
        }
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
        if (idempotent) {
            return this.checkPolicy(executionCount);
        }
        Boolean b = (Boolean)context.getAttribute("http.request_sent");
        boolean bl2 = sent = b != null && b != false;
        if (!sent) {
            return this.checkPolicy(executionCount);
        }
        return false;
    }

    private boolean checkPolicy(int executionCount) {
        if (this.mechanism.equalsIgnoreCase("fixedretry")) {
            if (this.retryCount == 0) {
                return false;
            }
            if (executionCount < this.retryCount) {
                try {
                    Thread.sleep(this.retryInterval);
                    LOG.debug("The retryInterval " + this.retryInterval);
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                }
            }
            return false;
        }
        if (this.mechanism.equalsIgnoreCase("incrementalretry")) {
            if (executionCount < this.retryCount) {
                try {
                    Thread.sleep((long)this.initialInterval + (long)(this.increment * executionCount));
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                }
            }
            return false;
        }
        if (this.mechanism.equalsIgnoreCase("exponentialretry")) {
            if (executionCount < this.retryCount) {
                try {
                    int delta = (int)((Math.pow(2.0, executionCount) - 1.0) * ((double)this.deltaBackoff * 0.8) + (Math.random() * ((double)this.deltaBackoff * 1.2) - (double)this.deltaBackoff * 0.8 + 1.0));
                    int interval = Math.min(this.minBackoff + delta, this.maxBackoff);
                    Thread.sleep(interval);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

