/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.compression.CompressorFactory;
import com.intuit.ipp.core.Context;
import com.intuit.ipp.core.IEntity;
import com.intuit.ipp.core.ServiceType;
import com.intuit.ipp.data.Attachable;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.RequestElements;
import com.intuit.ipp.interceptors.UploadRequestElements;
import com.intuit.ipp.net.ContentTypes;
import com.intuit.ipp.net.OperationType;
import com.intuit.ipp.util.Config;
import com.intuit.ipp.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;

public class PrepareRequestInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        String action;
        LOG.debug("Enter PrepareRequestInterceptor...");
        RequestElements requestElements = intuitMessage.getRequestElements();
        Map<String, String> requestParameters = requestElements.getRequestParameters();
        String string = action = requestElements.getAction() == null ? this.getEntityName(requestElements.getEntity()) : requestElements.getAction();
        if (intuitMessage.isPlatformService()) {
            requestParameters.put("uri", this.prepareIPSUri(action, requestElements.getContext()));
        } else if (intuitMessage.isEntitlementService()) {
            this.prepareEntitlementsRequest(intuitMessage, requestElements, requestParameters);
        } else {
            this.prepareDataServiceRequest(intuitMessage, requestElements, requestParameters, action);
        }
        LOG.debug("Exit PrepareRequestInterceptor.");
    }

    private void prepareDataServiceRequest(IntuitMessage intuitMessage, RequestElements requestElements, Map<String, String> requestParameters, String action) throws FMSException {
        requestParameters.put("uri", this.getUri(intuitMessage.isPlatformService(), action, requestElements.getContext(), requestParameters, intuitMessage.isEntitlementService()));
        Map<String, String> requestHeaders = requestElements.getRequestHeaders();
        if (this.isUpload(action)) {
            this.prepareUploadParams(requestElements);
        } else if (StringUtils.hasText(requestElements.getPostString())) {
            requestHeaders.put("content-type", ContentTypes.TEXT.toString());
        } else {
            String serializeFormat = this.getSerializationRequestFormat();
            if (StringUtils.hasText(serializeFormat) && !this.isSendEmail(requestParameters)) {
                requestHeaders.put("content-type", ContentTypes.getContentType(serializeFormat));
            } else if (StringUtils.hasText(serializeFormat) && this.isSendEmail(requestParameters)) {
                requestHeaders.put("content-type", ContentTypes.OCTECT_STREAM.toString());
            }
        }
        String compressFormat = Config.getProperty("message.request.compression");
        if (StringUtils.hasText(compressFormat) && CompressorFactory.isValidCompressFormat(compressFormat)) {
            requestHeaders.put("Content-Encoding", compressFormat);
        }
        this.setupAcceptEncoding(requestHeaders);
        this.setupAcceptHeader(action, requestHeaders, requestParameters);
        UUID trackingID = requestElements.getContext().getTrackingID();
        if (trackingID != null) {
            requestHeaders.put("intuit_tid", trackingID.toString());
        }
    }

    private void prepareEntitlementsRequest(IntuitMessage intuitMessage, RequestElements requestElements, Map<String, String> requestParameters) throws FMSException {
        requestParameters.put("uri", this.getUri(intuitMessage.isPlatformService(), null, requestElements.getContext(), requestParameters, intuitMessage.isEntitlementService()));
        Map<String, String> requestHeaders = requestElements.getRequestHeaders();
        requestHeaders.put("content-type", ContentTypes.XML.toString());
        requestHeaders.put("Accept", ContentTypes.XML.toString());
        String compressFormat = Config.getProperty("message.request.compression");
        if (StringUtils.hasText(compressFormat) && CompressorFactory.isValidCompressFormat(compressFormat)) {
            requestHeaders.put("Content-Encoding", compressFormat);
        }
        this.setupAcceptEncoding(requestHeaders);
        UUID trackingID = requestElements.getContext().getTrackingID();
        if (trackingID != null) {
            requestHeaders.put("intuit_tid", trackingID.toString());
        }
    }

    private void setupAcceptEncoding(Map<String, String> requestHeaders) {
        String acceptCompressionFormat = Config.getProperty("message.response.compression");
        if (StringUtils.hasText(acceptCompressionFormat)) {
            requestHeaders.put("Accept-Encoding", acceptCompressionFormat);
        }
    }

    private void setupAcceptHeader(String action, Map<String, String> requestHeaders, Map<String, String> requestParameters) {
        String serializeAcceptFormat = this.getSerializationResponseFormat();
        if (StringUtils.hasText(serializeAcceptFormat) && !this.isDownload(action) && !this.isDownloadPDF(requestParameters)) {
            requestHeaders.put("Accept", ContentTypes.getContentType(serializeAcceptFormat));
        }
        if (this.isDownloadPDF(requestParameters)) {
            requestHeaders.put("Accept", ContentTypes.getContentType(requestParameters.get("selector")));
        }
    }

    protected String getSerializationResponseFormat() {
        return Config.getProperty("message.response.serialization");
    }

    protected String getSerializationRequestFormat() {
        return Config.getProperty("message.request.serialization");
    }

    private <T extends IEntity> String getEntityName(T entity) {
        if (entity != null) {
            return entity.getClass().getSimpleName().toLowerCase();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends IEntity> String getUri(Boolean platformService, String action, Context context, Map<String, String> requestParameters, Boolean entitlementService) throws FMSException {
        String uri = null;
        if (platformService != false) return this.prepareIPSUri(action, context);
        ServiceType serviceType = context.getIntuitServiceType();
        if (entitlementService.booleanValue()) {
            return this.prepareEntitlementUri(context);
        }
        if (ServiceType.QBO == serviceType) {
            return this.prepareQBOUri(action, context, requestParameters);
        }
        if (ServiceType.QBOPremier != serviceType) throw new FMSException("SDK doesn't support for the service type : " + (Object)((Object)serviceType));
        return this.prepareQBOPremierUri(action, context, requestParameters);
    }

    protected String getBaseUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    private <T extends IEntity> String prepareQBOUri(String entityName, Context context, Map<String, String> requestParameters) throws FMSException {
        StringBuilder uri = new StringBuilder();
        if (entityName.equalsIgnoreCase("Taxservice")) {
            entityName = entityName + "/taxcode";
        }
        if (entityName.equalsIgnoreCase("CreditCardPaymentTxn")) {
            entityName = "creditcardpayment";
        }
        uri.append(this.getBaseUrl(Config.getProperty("baseURL.qbo"))).append("/").append(context.getRealmID()).append("/").append(entityName);
        this.addEntityID(requestParameters, uri);
        this.addEntitySelector(requestParameters, uri);
        this.addParentID(requestParameters, uri);
        uri.append("?").append(this.buildRequestParams(requestParameters));
        uri.append("requestid").append("=").append(context.getRequestID()).append("&");
        context.setRequestID(null);
        if (context.getMinorVersion() == null) {
            context.setMinorVersion(Config.getProperty("minorVersion.latestMinorVersion"));
        }
        uri.append("minorversion").append("=").append(context.getMinorVersion()).append("&");
        if (context.getIncludeParam() != null) {
            int includeval = context.getIncludeParam().size();
            String includeParam = "";
            if (includeval > 0) {
                for (int i = 0; i < includeval; ++i) {
                    includeParam = includeParam + context.getIncludeParam().get(i) + ",";
                }
                uri.append("include").append("=").append(includeParam.substring(0, includeParam.length() - 1)).append("&");
            }
        }
        return uri.toString();
    }

    private void addEntityID(Map<String, String> requestParameters, StringBuilder uri) {
        if (StringUtils.hasText(requestParameters.get("entityid"))) {
            uri.append("/").append(requestParameters.get("entityid"));
        }
    }

    private void addEntitySelector(Map<String, String> requestParameters, StringBuilder uri) {
        if (StringUtils.hasText(requestParameters.get("selector"))) {
            uri.append("/").append(requestParameters.get("selector"));
        }
    }

    private void addParentID(Map<String, String> requestParameters, StringBuilder uri) {
        if (StringUtils.hasText(requestParameters.get("parentid"))) {
            uri.append("/").append(requestParameters.get("parentid")).append("/children");
        }
    }

    private <T extends IEntity> String prepareQBOPremierUri(String entityName, Context context, Map<String, String> requestParameters) throws FMSException {
        StringBuilder uri = new StringBuilder();
        uri.append(Config.getProperty("BASE_URL_QBO_OLB")).append("/").append(context.getRealmID()).append("/").append(entityName);
        this.addEntityID(requestParameters, uri);
        this.addEntitySelector(requestParameters, uri);
        uri.append("?").append(this.buildRequestParams(requestParameters));
        uri.append("requestid").append("=").append(context.getRequestID()).append("&");
        context.setRequestID(null);
        if (context.getMinorVersion() != null) {
            uri.append("minorversion").append("=").append(context.getMinorVersion()).append("&");
        }
        return uri.toString();
    }

    private String prepareIPSUri(String action, Context context) throws FMSException {
        StringBuilder uri = new StringBuilder();
        uri.append(Config.getProperty("baseURL.platformService")).append("/").append(context.getAppDBID()).append("?act=").append(action).append("&token=").append(context.getAppToken());
        return uri.toString();
    }

    private String prepareEntitlementUri(Context context) throws FMSException {
        StringBuilder uri = new StringBuilder();
        uri.append(this.getBaseUrl(Config.getProperty("baseURL.entitlementService"))).append("/").append("entitlements").append("/").append("v3").append("/").append(context.getRealmID());
        uri.append("?").append("requestid").append("=").append(context.getRequestID()).append("&");
        context.setRequestID(null);
        if (context.getMinorVersion() == null) {
            context.setMinorVersion("43");
        }
        uri.append("minorversion").append("=").append(context.getMinorVersion()).append("&");
        return uri.toString();
    }

    private String buildRequestParams(Map<String, String> requestParameters) throws FMSException {
        StringBuilder reqParams = new StringBuilder();
        Set<String> keySet = requestParameters.keySet();
        for (String key : keySet) {
            String value = requestParameters.get(key);
            if (this.isKeyValueExpected(key)) {
                if (value == "updateAccountOnTxns") {
                    reqParams.append("include").append("=").append("updateaccountontxns").append("&");
                    continue;
                }
                if (value == "donotUpdateAccountOnTxns") {
                    reqParams.append("include").append("=").append("donotupdateaccountontxns").append("&");
                    continue;
                }
                reqParams.append(key).append("=").append(value).append("&");
                continue;
            }
            if (!key.equals("query") && !key.equals("entities")) continue;
            try {
                String encodedQuery = URLEncoder.encode(value, "UTF-8");
                reqParams.append(key).append("=").append(encodedQuery).append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new FMSException("UnsupportedEncodingException", e);
            }
        }
        return reqParams.toString();
    }

    private boolean isKeyValueExpected(String key) {
        return key.equals("operation") || key.equals("include") || key.equals("changedSince") || key.equals("lastUpdatedTime") || key.equals("accountid") || key.equals("numberofdays") || key.equals("startPosition") || key.equals("maxresults") || key.equals("sendTo") || key.equals("level") || key.equals("start_date") || key.equals("end_date") || key.equals("date_macro") || key.equals("accounting_method") || key.equals("summarize_column_by") || key.equals("customer") || key.equals("vendor") || key.equals("item") || key.equals("class") || key.equals("department") || key.equals("qzurl") || key.equals("aging_period") || key.equals("num_periods") || key.equals("report_date") || key.equals("columns") || key.equals("account") || key.equals("account_type") || key.equals("source_account_type") || key.equals("sort_by") || key.equals("sort_order") || key.equals("source_account") || key.equals("payment_method") || key.equals("start_duedate") || key.equals("end_duedate") || key.equals("appaid") || key.equals("arpaid") || key.equals("bothamount") || key.equals("cleared") || key.equals("createdate_macro") || key.equals("docnum") || key.equals("duedate_macro") || key.equals("group_by") || key.equals("memo") || key.equals("moddate_macro") || key.equals("name") || key.equals("printed") || key.equals("end_moddate") || key.equals("start_moddate") || key.equals("term") || key.equals("transaction_type") || key.equals("aging_method") || key.equals("past_due") || key.equals("createdate_macro") || key.equals("end_createdate") || key.equals("start_createdate") || key.equals("journal_code") || key.equals("employee") || key.equals("agency_id") || key.equals("custom1") || key.equals("custom2") || key.equals("custom3") || key.equals("shipvia") || key.equals("account_status") || key.equals("subcol_pct_inc") || key.equals("subcol_pct_exp");
    }

    private void prepareUploadParams(RequestElements requestElements) {
        Map<String, String> requestHeaders = requestElements.getRequestHeaders();
        UploadRequestElements uploadRequestElements = requestElements.getUploadRequestElements();
        String boundaryId = uploadRequestElements.getBoundaryId();
        String formMetadataName = "file_metadata_" + boundaryId.substring(0, 5) + "_" + uploadRequestElements.getElementsId();
        String formContentName = "file_content_" + boundaryId.substring(0, 5) + "_" + uploadRequestElements.getElementsId();
        String contentType = ContentTypes.getContentType(this.getSerializationRequestFormat());
        Attachable attachable = (Attachable)requestElements.getEntity();
        String fileName = attachable.getFileName() != null ? "; filename=\"" + attachable.getFileName() + "\"" : "";
        String fileType = attachable.getContentType() != null ? "Content-Type: " + attachable.getContentType() + "\r\n" : "";
        String entityBoundary = String.format("\r\n--%s\r\nContent-Disposition: form-data; name=\"%s\"\r\nContent-Type: %s\r\n\r\n", boundaryId, formMetadataName, contentType);
        String contentBoundary = String.format("\r\n\r\n--%s\r\nContent-Disposition: form-data; name=\"%s\" %s\r\n%s\r\n", boundaryId, formContentName, fileName, fileType);
        requestHeaders.put("content-type", ContentTypes.MULTIPART_FORMDATA.toString() + "; boundary=" + boundaryId);
        uploadRequestElements.setBoundaryForEntity(entityBoundary);
        uploadRequestElements.setBoundaryForContent(contentBoundary);
    }

    private boolean isDownload(String action) {
        return StringUtils.hasText(action) && action.equals(OperationType.DOWNLOAD.toString());
    }

    private boolean isDownloadPDF(Map<String, String> map) {
        return StringUtils.hasText(map.get("selector")) && map.get("selector").equalsIgnoreCase(ContentTypes.PDF.name());
    }

    private boolean isSendEmail(Map<String, String> map) {
        return StringUtils.hasText(map.get("selector")) && map.get("selector").equalsIgnoreCase("send");
    }

    private boolean isUpload(String action) {
        return StringUtils.hasText(action) && action.equals(OperationType.UPLOAD.toString());
    }
}

