/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.interceptors;

import com.intuit.ipp.data.EntitlementsResponse;
import com.intuit.ipp.data.Fault;
import com.intuit.ipp.data.IntuitResponse;
import com.intuit.ipp.data.TaxService;
import com.intuit.ipp.exception.AuthenticationException;
import com.intuit.ipp.exception.AuthorizationException;
import com.intuit.ipp.exception.BadRequestException;
import com.intuit.ipp.exception.FMSException;
import com.intuit.ipp.exception.InternalServiceException;
import com.intuit.ipp.exception.InvalidRequestException;
import com.intuit.ipp.exception.InvalidTokenException;
import com.intuit.ipp.exception.ServiceException;
import com.intuit.ipp.exception.ServiceUnavailableException;
import com.intuit.ipp.exception.ValidationException;
import com.intuit.ipp.interceptors.Interceptor;
import com.intuit.ipp.interceptors.IntuitMessage;
import com.intuit.ipp.interceptors.ResponseElements;
import org.apache.http.StatusLine;
import org.slf4j.Logger;

public class HandleResponseInterceptor
implements Interceptor {
    private static final Logger LOG = com.intuit.ipp.util.Logger.getLogger();
    private static final int HTTP_ERROR_400 = 400;
    private static final int HTTP_ERROR_401 = 401;
    private static final int HTTP_ERROR_403 = 403;
    private static final int HTTP_ERROR_404 = 404;
    private static final int HTTP_ERROR_500 = 500;
    private static final int HTTP_ERROR_503 = 503;
    private static final int HTTP_ERROR_429 = 429;

    @Override
    public void execute(IntuitMessage intuitMessage) throws FMSException {
        LOG.debug("Enter HandleResponseInterceptor...");
        IntuitResponse intuitResponse = null;
        ResponseElements responseElements = intuitMessage.getResponseElements();
        if (responseElements.getResponse() instanceof TaxService) {
            LOG.debug("Tax Service Response");
        } else if (responseElements.getResponse() instanceof EntitlementsResponse) {
            LOG.debug("Entitlements Response");
        } else {
            intuitResponse = (IntuitResponse)responseElements.getResponse();
        }
        if (intuitResponse != null && intuitResponse.getFault() != null) {
            Fault fault = intuitResponse.getFault();
            if (fault.getType().equalsIgnoreCase("Validation")) {
                throw new ValidationException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("Service")) {
                throw new ServiceException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("AuthenticationFault")) {
                throw new AuthenticationException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("Authentication")) {
                throw new AuthenticationException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("ApplicationAuthenticationFailed")) {
                throw new AuthenticationException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("Authorization")) {
                throw new AuthorizationException(fault.getError());
            }
            if (fault.getType().equalsIgnoreCase("AuthorizationFault")) {
                throw new AuthorizationException(fault.getError());
            }
            throw new FMSException(fault.getError());
        }
        if (intuitResponse == null) {
            StatusLine statusLine = responseElements.getStatusLine();
            String responseMessage = statusLine.getReasonPhrase();
            int status = responseElements.getStatusCode();
            if (responseMessage == null) {
                responseMessage = Integer.toString(status);
            }
            if (status == 400) {
                throw new BadRequestException(responseMessage);
            }
            if (status == 401) {
                throw new InvalidTokenException(responseMessage);
            }
            if (status == 403) {
                throw new InvalidRequestException(responseMessage);
            }
            if (status == 404) {
                throw new InvalidRequestException(responseMessage);
            }
            if (status == 500) {
                throw new InternalServiceException(responseMessage);
            }
            if (status == 503) {
                throw new ServiceUnavailableException(responseMessage);
            }
            if (status == 429) {
                throw new ServiceException(responseMessage);
            }
        }
        LOG.debug("Exit HandleResponseInterceptor.");
    }
}

