/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.compression;

import com.intuit.ipp.compression.DeflateCompressor;
import com.intuit.ipp.compression.GZIPCompressor;
import com.intuit.ipp.compression.ICompressor;
import com.intuit.ipp.exception.CompressionException;
import com.intuit.ipp.util.StringUtils;

public final class CompressorFactory {
    public static final String GZIP_COMPRESS_FORMAT = "gzip";
    public static final String DEFLATE_COMPRESS_FORMAT = "deflate";

    private CompressorFactory() {
    }

    public static CompressorFactory getInstance() {
        return new CompressorFactory();
    }

    public static ICompressor getCompressor(String compressFormat) throws CompressionException {
        ICompressor compressor = null;
        if (CompressorFactory.isValidCompressFormat(compressFormat)) {
            if (compressFormat.equalsIgnoreCase(GZIP_COMPRESS_FORMAT)) {
                compressor = new GZIPCompressor();
            } else if (compressFormat.equalsIgnoreCase(DEFLATE_COMPRESS_FORMAT)) {
                compressor = new DeflateCompressor();
            }
        }
        return compressor;
    }

    public static boolean isValidCompressFormat(String compressFormat) throws CompressionException {
        if (!StringUtils.hasText(compressFormat)) {
            throw new CompressionException("Compress format is either null or empty!");
        }
        if (compressFormat.equalsIgnoreCase(GZIP_COMPRESS_FORMAT) || compressFormat.equalsIgnoreCase(DEFLATE_COMPRESS_FORMAT)) {
            return true;
        }
        throw new CompressionException("There is no compression technique for the given compress format : " + compressFormat);
    }
}

