/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.LogLevel;
import com.influxdb.client.AuthorizationsApi;
import com.influxdb.client.BucketsApi;
import com.influxdb.client.ChecksApi;
import com.influxdb.client.DashboardsApi;
import com.influxdb.client.DeleteApi;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.LabelsApi;
import com.influxdb.client.NotificationEndpointsApi;
import com.influxdb.client.NotificationRulesApi;
import com.influxdb.client.OrganizationsApi;
import com.influxdb.client.QueryApi;
import com.influxdb.client.ScraperTargetsApi;
import com.influxdb.client.SourcesApi;
import com.influxdb.client.TasksApi;
import com.influxdb.client.TelegrafsApi;
import com.influxdb.client.TemplatesApi;
import com.influxdb.client.UsersApi;
import com.influxdb.client.VariablesApi;
import com.influxdb.client.WriteApi;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.WriteOptions;
import com.influxdb.client.domain.HealthCheck;
import com.influxdb.client.domain.IsOnboarding;
import com.influxdb.client.domain.OnboardingRequest;
import com.influxdb.client.domain.OnboardingResponse;
import com.influxdb.client.domain.Ready;
import com.influxdb.client.internal.AbstractInfluxDBClient;
import com.influxdb.client.internal.AuthorizationsApiImpl;
import com.influxdb.client.internal.BucketsApiImpl;
import com.influxdb.client.internal.ChecksApiImpl;
import com.influxdb.client.internal.DashboardsApiImpl;
import com.influxdb.client.internal.DeleteApiImpl;
import com.influxdb.client.internal.LabelsApiImpl;
import com.influxdb.client.internal.NotificationEndpointsApiImpl;
import com.influxdb.client.internal.NotificationRulesApiImpl;
import com.influxdb.client.internal.OrganizationsApiImpl;
import com.influxdb.client.internal.QueryApiImpl;
import com.influxdb.client.internal.ScraperTargetsApiImpl;
import com.influxdb.client.internal.SourcesApiImpl;
import com.influxdb.client.internal.TasksApiImpl;
import com.influxdb.client.internal.TelegrafsApiImpl;
import com.influxdb.client.internal.TemplatesApiImpl;
import com.influxdb.client.internal.UsersApiImpl;
import com.influxdb.client.internal.VariablesApiImpl;
import com.influxdb.client.internal.WriteApiBlockingImpl;
import com.influxdb.client.internal.WriteApiImpl;
import com.influxdb.client.service.AuthorizationsService;
import com.influxdb.client.service.BucketsService;
import com.influxdb.client.service.ChecksService;
import com.influxdb.client.service.DashboardsService;
import com.influxdb.client.service.DeleteService;
import com.influxdb.client.service.LabelsService;
import com.influxdb.client.service.NotificationEndpointsService;
import com.influxdb.client.service.NotificationRulesService;
import com.influxdb.client.service.OrganizationsService;
import com.influxdb.client.service.QueryService;
import com.influxdb.client.service.ReadyService;
import com.influxdb.client.service.ScraperTargetsService;
import com.influxdb.client.service.SecretsService;
import com.influxdb.client.service.SetupService;
import com.influxdb.client.service.SourcesService;
import com.influxdb.client.service.TasksService;
import com.influxdb.client.service.TelegrafsService;
import com.influxdb.client.service.TemplatesService;
import com.influxdb.client.service.UsersService;
import com.influxdb.client.service.VariablesService;
import com.influxdb.client.service.WriteService;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.exceptions.UnprocessableEntityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

public final class InfluxDBClientImpl
extends AbstractInfluxDBClient
implements InfluxDBClient {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private final SetupService setupService;
    private final ReadyService readyService;

    public InfluxDBClientImpl(@Nonnull InfluxDBClientOptions options) {
        super(options, "java");
        this.setupService = (SetupService)this.retrofit.create(SetupService.class);
        this.readyService = (ReadyService)this.retrofit.create(ReadyService.class);
    }

    @Override
    @Nonnull
    public QueryApi getQueryApi() {
        return new QueryApiImpl((QueryService)this.retrofit.create(QueryService.class), this.options);
    }

    @Override
    @Nonnull
    public WriteApi getWriteApi() {
        return this.getWriteApi(WriteOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public WriteApi getWriteApi(@Nonnull WriteOptions writeOptions) {
        Arguments.checkNotNull((Object)writeOptions, (String)"WriteOptions");
        return new WriteApiImpl(writeOptions, (WriteService)this.retrofit.create(WriteService.class), this.options, this.autoCloseables);
    }

    @Override
    @Nonnull
    public WriteApiBlocking getWriteApiBlocking() {
        return new WriteApiBlockingImpl((WriteService)this.retrofit.create(WriteService.class), this.options);
    }

    @Override
    @Nonnull
    public AuthorizationsApi getAuthorizationsApi() {
        return new AuthorizationsApiImpl((AuthorizationsService)this.retrofit.create(AuthorizationsService.class));
    }

    @Override
    @Nonnull
    public BucketsApi getBucketsApi() {
        return new BucketsApiImpl((BucketsService)this.retrofit.create(BucketsService.class));
    }

    @Override
    @Nonnull
    public OrganizationsApi getOrganizationsApi() {
        return new OrganizationsApiImpl((OrganizationsService)this.retrofit.create(OrganizationsService.class), (SecretsService)this.retrofit.create(SecretsService.class));
    }

    @Override
    @Nonnull
    public SourcesApi getSourcesApi() {
        return new SourcesApiImpl((SourcesService)this.retrofit.create(SourcesService.class), this);
    }

    @Override
    @Nonnull
    public TasksApi getTasksApi() {
        return new TasksApiImpl((TasksService)this.retrofit.create(TasksService.class));
    }

    @Override
    @Nonnull
    public UsersApi getUsersApi() {
        return new UsersApiImpl((UsersService)this.retrofit.create(UsersService.class));
    }

    @Override
    @Nonnull
    public ScraperTargetsApi getScraperTargetsApi() {
        return new ScraperTargetsApiImpl((ScraperTargetsService)this.retrofit.create(ScraperTargetsService.class));
    }

    @Override
    @Nonnull
    public TelegrafsApi getTelegrafsApi() {
        return new TelegrafsApiImpl((TelegrafsService)this.retrofit.create(TelegrafsService.class));
    }

    @Override
    @Nonnull
    public LabelsApi getLabelsApi() {
        return new LabelsApiImpl((LabelsService)this.retrofit.create(LabelsService.class));
    }

    @Override
    @Nonnull
    public TemplatesApi getTemplatesApi() {
        return new TemplatesApiImpl((TemplatesService)this.retrofit.create(TemplatesService.class));
    }

    @Override
    @Nonnull
    public VariablesApi getVariablesApi() {
        return new VariablesApiImpl((VariablesService)this.retrofit.create(VariablesService.class));
    }

    @Override
    @Nonnull
    public DashboardsApi getDashboardsApi() {
        return new DashboardsApiImpl((DashboardsService)this.retrofit.create(DashboardsService.class));
    }

    @Override
    @Nonnull
    public ChecksApi getChecksApi() {
        return new ChecksApiImpl((ChecksService)this.retrofit.create(ChecksService.class));
    }

    @Override
    @Nonnull
    public NotificationEndpointsApi getNotificationEndpointsApi() {
        return new NotificationEndpointsApiImpl((NotificationEndpointsService)this.retrofit.create(NotificationEndpointsService.class));
    }

    @Override
    @Nonnull
    public NotificationRulesApi getNotificationRulesApi() {
        return new NotificationRulesApiImpl((NotificationRulesService)this.retrofit.create(NotificationRulesService.class));
    }

    @Override
    @Nonnull
    public DeleteApi getDeleteApi() {
        return new DeleteApiImpl((DeleteService)this.retrofit.create(DeleteService.class));
    }

    @Override
    @Nonnull
    public <S> S getService(@Nonnull Class<S> service) {
        Arguments.checkNotNull(service, (String)"service");
        return (S)this.retrofit.create(service);
    }

    @Override
    @Nonnull
    public HealthCheck health() {
        return this.health(this.healthService.getHealth(null));
    }

    @Override
    @Nullable
    public Ready ready() {
        Call<Ready> call = this.readyService.getReady(null);
        try {
            return (Ready)this.execute(call);
        }
        catch (InfluxException e) {
            LOG.log(Level.WARNING, "The exception occurs during check instance readiness", e);
            return null;
        }
    }

    @Override
    @Nonnull
    public OnboardingResponse onBoarding(@Nonnull OnboardingRequest onboarding) throws UnprocessableEntityException {
        Arguments.checkNotNull((Object)onboarding, (String)"onboarding");
        Call<OnboardingResponse> call = this.setupService.postSetup(onboarding, null);
        return (OnboardingResponse)this.execute(call);
    }

    @Override
    @Nonnull
    public Boolean isOnboardingAllowed() {
        IsOnboarding isOnboarding = (IsOnboarding)this.execute(this.setupService.getSetup(null));
        return isOnboarding.getAllowed();
    }

    @Override
    @Nonnull
    public LogLevel getLogLevel() {
        return this.getLogLevel(this.loggingInterceptor);
    }

    @Override
    @Nonnull
    public InfluxDBClient setLogLevel(@Nonnull LogLevel logLevel) {
        this.setLogLevel(this.loggingInterceptor, logLevel);
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClient enableGzip() {
        this.gzipInterceptor.enableGzip();
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClient disableGzip() {
        this.gzipInterceptor.disableGzip();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipInterceptor.isEnabledGzip();
    }
}

