/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.ChecksApi;
import com.influxdb.client.FindOptions;
import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.CheckPatch;
import com.influxdb.client.domain.CheckStatusLevel;
import com.influxdb.client.domain.Checks;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.DeadmanCheck;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.QueryEditMode;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.domain.Threshold;
import com.influxdb.client.domain.ThresholdCheck;
import com.influxdb.client.service.ChecksService;
import com.influxdb.internal.AbstractRestClient;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import retrofit2.Call;

final class ChecksApiImpl
extends AbstractRestClient
implements ChecksApi {
    private final ChecksService service;

    ChecksApiImpl(ChecksService service) {
        Arguments.checkNotNull((Object)service, (String)"checksService");
        this.service = service;
    }

    @Override
    @Nonnull
    public ThresholdCheck createThresholdCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull Threshold threshold, @Nonnull String orgID) {
        Arguments.checkNotNull((Object)threshold, (String)"threshold");
        List<Threshold> thresholds = Collections.singletonList(threshold);
        return this.createThresholdCheck(name, query, every, messageTemplate, thresholds, orgID);
    }

    @Override
    @Nonnull
    public ThresholdCheck createThresholdCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull List<Threshold> thresholds, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkDuration((String)every, (String)"every");
        Arguments.checkNonEmpty((String)messageTemplate, (String)"messageTemplate");
        Arguments.checkNotNull(thresholds, (String)"thresholds");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        ThresholdCheck threshold = new ThresholdCheck();
        threshold.every(every).statusMessageTemplate(messageTemplate).thresholds(thresholds).name(name).orgID(orgID).query(this.createDashboardQuery(query)).status(TaskStatusType.ACTIVE);
        return (ThresholdCheck)this.createCheck(threshold);
    }

    @Override
    @Nonnull
    public DeadmanCheck createDeadmanCheck(@Nonnull String name, @Nonnull String query, @Nonnull String every, @Nonnull String timeSince, @Nonnull String staleTime, @Nonnull String messageTemplate, @Nonnull CheckStatusLevel level, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkDuration((String)every, (String)"every");
        Arguments.checkDuration((String)timeSince, (String)"timeSince");
        Arguments.checkDuration((String)staleTime, (String)"staleTime");
        Arguments.checkNonEmpty((String)messageTemplate, (String)"messageTemplate");
        Arguments.checkNotNull((Object)((Object)level), (String)"level");
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        DeadmanCheck deadman = new DeadmanCheck();
        deadman.every(every).statusMessageTemplate(messageTemplate).level(level).staleTime(staleTime).timeSince(timeSince).name(name).orgID(orgID).query(this.createDashboardQuery(query)).status(TaskStatusType.ACTIVE);
        return (DeadmanCheck)this.createCheck(deadman);
    }

    @Override
    @Nonnull
    public Check createCheck(@Nonnull Check check) {
        Arguments.checkNotNull((Object)check, (String)"check");
        Call<Check> call = this.service.createCheck(check);
        return (Check)this.execute(call);
    }

    @Override
    @Nonnull
    public Check updateCheck(@Nonnull Check check) {
        Arguments.checkNotNull((Object)check, (String)"check");
        CheckPatch patch = new CheckPatch().name(check.getName()).description(check.getDescription()).status(CheckPatch.StatusEnum.fromValue(check.getStatus().getValue()));
        return this.updateCheck(check.getId(), patch);
    }

    @Override
    @Nonnull
    public Check updateCheck(@Nonnull String checkID, @Nonnull CheckPatch patch) {
        Arguments.checkNotNull((Object)checkID, (String)"checkID");
        Arguments.checkNotNull((Object)patch, (String)"patch");
        Call<Check> call = this.service.patchChecksID(checkID, patch, null);
        return (Check)this.execute(call);
    }

    @Override
    public void deleteCheck(@Nonnull Check check) {
        Arguments.checkNotNull((Object)check, (String)"check");
        this.deleteCheck(check.getId());
    }

    @Override
    public void deleteCheck(@Nonnull String checkID) {
        Arguments.checkNotNull((Object)checkID, (String)"checkID");
        Call<Void> call = this.service.deleteChecksID(checkID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Check findCheckByID(@Nonnull String checkID) {
        Arguments.checkNotNull((Object)checkID, (String)"checkID");
        Call<Check> call = this.service.getChecksID(checkID, null);
        return (Check)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Check> findChecks(@Nonnull String orgID) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        return this.findChecks(orgID, new FindOptions()).getChecks();
    }

    @Override
    @Nonnull
    public Checks findChecks(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty((String)orgID, (String)"orgID");
        Arguments.checkNotNull((Object)findOptions, (String)"findOptions");
        Call<Checks> call = this.service.getChecks(orgID, null, findOptions.getOffset(), findOptions.getLimit());
        return (Checks)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Check check) {
        Arguments.checkNotNull((Object)check, (String)"check");
        return this.getLabels(check.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String checkID) {
        Arguments.checkNonEmpty((String)checkID, (String)"checkID");
        Call<LabelsResponse> call = this.service.getChecksIDLabels(checkID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Check check) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)check, (String)"check");
        return this.addLabel(label.getId(), check.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String checkID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)checkID, (String)"checkID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postChecksIDLabels(checkID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Check check) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)check, (String)"check");
        this.deleteLabel(label.getId(), check.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String checkID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)checkID, (String)"checkID");
        Call<Void> call = this.service.deleteChecksIDLabelsID(checkID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private DashboardQuery createDashboardQuery(@Nonnull String query) {
        return new DashboardQuery().editMode(QueryEditMode.ADVANCED).text(query);
    }
}

