/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.transport;

import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionListenerResponseHandler;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.ActionType;
import org.easysearch.client.Client;
import org.easysearch.client.support.AbstractClient;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.settings.Settings;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.RemoteClusterAwareRequest;
import org.easysearch.transport.RemoteClusterService;
import org.easysearch.transport.Transport;
import org.easysearch.transport.TransportRequest;
import org.easysearch.transport.TransportRequestOptions;
import org.easysearch.transport.TransportService;

final class RemoteClusterAwareClient
extends AbstractClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;

    RemoteClusterAwareClient(Settings settings, ThreadPool threadPool, TransportService service, String clusterAlias) {
        super(settings, threadPool);
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.wrap(v -> {
            Transport.Connection connection;
            if (request instanceof RemoteClusterAwareRequest) {
                DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
            } else {
                connection = this.remoteClusterService.getConnection(this.clusterAlias);
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(listener, action.getResponseReader()));
        }, listener::onFailure));
    }

    @Override
    public void close() {
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }
}

