/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.easysearch.action.search.SearchShardTask;
import org.easysearch.common.Nullable;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.lucene.Lucene;
import org.easysearch.search.RescoreDocIds;
import org.easysearch.search.dfs.AggregatedDfs;
import org.easysearch.search.internal.ShardSearchContextId;
import org.easysearch.search.internal.ShardSearchRequest;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;
import org.easysearch.transport.TransportRequest;

public class ShardFetchRequest
extends TransportRequest {
    private ShardSearchContextId contextId;
    private int[] docIds;
    private int size;
    private ScoreDoc lastEmittedDoc;

    public ShardFetchRequest(ShardSearchContextId contextId, IntArrayList list, ScoreDoc lastEmittedDoc) {
        this.contextId = contextId;
        this.docIds = list.buffer;
        this.size = list.size();
        this.lastEmittedDoc = lastEmittedDoc;
    }

    public ShardFetchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.docIds[i] = in.readVInt();
        }
        byte flag = in.readByte();
        if (flag == 1) {
            this.lastEmittedDoc = Lucene.readFieldDoc(in);
        } else if (flag == 2) {
            this.lastEmittedDoc = Lucene.readScoreDoc(in);
        } else if (flag != 0) {
            throw new IOException("Unknown flag: " + flag);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.docIds[i]);
        }
        if (this.lastEmittedDoc == null) {
            out.writeByte((byte)0);
        } else if (this.lastEmittedDoc instanceof FieldDoc) {
            out.writeByte((byte)1);
            Lucene.writeFieldDoc(out, (FieldDoc)this.lastEmittedDoc);
        } else {
            out.writeByte((byte)2);
            Lucene.writeScoreDoc(out, this.lastEmittedDoc);
        }
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    public ScoreDoc lastEmittedDoc() {
        return this.lastEmittedDoc;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "id[" + this.contextId + "], size[" + this.size + "], lastEmittedDoc[" + this.lastEmittedDoc + "]";
    }

    @Nullable
    public ShardSearchRequest getShardSearchRequest() {
        return null;
    }

    @Nullable
    public RescoreDocIds getRescoreDocIds() {
        return null;
    }

    @Nullable
    public AggregatedDfs getAggregatedDfs() {
        return null;
    }
}

