/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.internal.SearchContext;

public abstract class ValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected ValuesSourceConfig config;

    public ValuesSourceAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (!this.config.hasValues()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return this.doCreateInternal(searchContext, parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(SearchContext var1, Aggregator var2, CardinalityUpperBound var3, Map<String, Object> var4) throws IOException;

    @Override
    public String getStatsSubtype() {
        return this.config.valueSourceType().typeName();
    }
}

