/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Map;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.pipeline.BucketHelpers;
import org.easysearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.easysearch.search.aggregations.pipeline.InternalExtendedStatsBucket;

public class ExtendedStatsBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private final double sigma;
    private double sum = 0.0;
    private long count = 0L;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double sumOfSqrs = 1.0;

    ExtendedStatsBucketPipelineAggregator(String name, String[] bucketsPaths, double sigma, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
        this.sigma = sigma;
    }

    public ExtendedStatsBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.sigma = in.readDouble();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sigma);
    }

    @Override
    public String getWriteableName() {
        return "extended_stats_bucket";
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
        this.count = 0L;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.sumOfSqrs = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
        this.min = Math.min(this.min, bucketValue);
        this.max = Math.max(this.max, bucketValue);
        ++this.count;
        this.sumOfSqrs += bucketValue * bucketValue;
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        return new InternalExtendedStatsBucket(this.name(), this.count, this.sum, this.min, this.max, this.sumOfSqrs, this.sigma, this.format, metadata);
    }
}

