/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.easysearch.search.aggregations.metrics.WeightedAvgAggregator;
import org.easysearch.search.aggregations.support.MultiValuesSource;
import org.easysearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.internal.SearchContext;

class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, DocValueFormat format, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, format, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs, this.queryShardContext);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, searchContext, parent, metadata);
    }

    @Override
    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName())).valueSourceType().typeName();
    }
}

