/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.easysearch.search.aggregations.metrics.CardinalityAggregator;
import org.easysearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Long precisionThreshold;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, Long precisionThreshold, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.precisionThreshold = precisionThreshold;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.ALL_CORE, CardinalityAggregator::new, true);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new CardinalityAggregator(this.name, this.config, this.precision(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(CardinalityAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.config, this.precision(), searchContext, parent, metadata);
    }

    private int precision() {
        return this.precisionThreshold == null ? 14 : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }
}

