/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.easysearch.common.lease.Releasables;
import org.easysearch.common.util.BigArrays;
import org.easysearch.common.util.DoubleArray;
import org.easysearch.common.util.LongArray;
import org.easysearch.index.fielddata.SortedNumericDoubleValues;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.LeafBucketCollector;
import org.easysearch.search.aggregations.LeafBucketCollectorBase;
import org.easysearch.search.aggregations.metrics.CompensatedSum;
import org.easysearch.search.aggregations.metrics.InternalAvg;
import org.easysearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.internal.SearchContext;

class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    AvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AvgAggregator.this.counts = bigArrays.grow(AvgAggregator.this.counts, bucket + 1L);
                AvgAggregator.this.sums = bigArrays.grow(AvgAggregator.this.sums, bucket + 1L);
                AvgAggregator.this.compensations = bigArrays.grow(AvgAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    AvgAggregator.this.counts.increment(bucket, valueCount);
                    double sum = AvgAggregator.this.sums.get(bucket);
                    double compensation = AvgAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    AvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    AvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.sums, this.compensations);
    }
}

