/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.AggregationInitializationException;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.bucket.filter.FilterAggregator;
import org.easysearch.search.internal.SearchContext;

public class FilterAggregatorFactory
extends AggregatorFactory {
    private Weight weight;
    private Query filter;

    public FilterAggregatorFactory(String name, QueryBuilder filterBuilder, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.filter = filterBuilder.toQuery(queryShardContext);
    }

    public Weight getWeight() {
        if (this.weight == null) {
            IndexSearcher contextSearcher = this.queryShardContext.searcher();
            try {
                this.weight = contextSearcher.createWeight(contextSearcher.rewrite(this.filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialse filter", e);
            }
        }
        return this.weight;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new FilterAggregator(this.name, () -> this.getWeight(), this.factories, searchContext, parent, cardinality, metadata);
    }
}

