/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.easysearch.common.ParseField;
import org.easysearch.common.Rounding;
import org.easysearch.common.collect.List;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.easysearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.easysearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.easysearch.search.aggregations.bucket.composite.LongValuesSource;
import org.easysearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.easysearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.easysearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.easysearch.search.aggregations.bucket.histogram.DateIntervalWrapper;
import org.easysearch.search.aggregations.bucket.histogram.Histogram;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.aggregations.support.ValuesSourceType;
import org.easysearch.search.sort.SortOrder;

public class DateHistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<DateHistogramValuesSourceBuilder>
implements DateIntervalConsumer {
    static final String TYPE = "date_histogram";
    static final ValuesSourceRegistry.RegistryKey<DateHistogramCompositeSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<DateHistogramCompositeSupplier>("date_histogram", DateHistogramCompositeSupplier.class);
    static final ObjectParser<DateHistogramValuesSourceBuilder, String> PARSER = ObjectParser.fromBuilder("date_histogram", DateHistogramValuesSourceBuilder::new);
    private ZoneId timeZone = null;
    private DateIntervalWrapper dateHistogramInterval = new DateIntervalWrapper();
    private long offset = 0L;

    public DateHistogramValuesSourceBuilder(String name) {
        super(name);
    }

    protected DateHistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.dateHistogramInterval = new DateIntervalWrapper(in);
        this.timeZone = in.readOptionalZoneId();
        this.offset = in.readLong();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.dateHistogramInterval.writeTo(out);
        out.writeOptionalZoneId(this.timeZone);
        out.writeLong(this.offset);
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.dateHistogramInterval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateHistogramInterval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateHistogramValuesSourceBuilder other = (DateHistogramValuesSourceBuilder)obj;
        return Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.timeZone, other.timeZone);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    @Deprecated
    public long interval() {
        return this.dateHistogramInterval.interval();
    }

    @Deprecated
    public DateHistogramValuesSourceBuilder interval(long interval) {
        this.dateHistogramInterval.interval(interval);
        return this;
    }

    @Override
    @Deprecated
    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval.dateHistogramInterval();
    }

    @Deprecated
    public DateHistogramValuesSourceBuilder dateHistogramInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.dateHistogramInterval(interval);
        return this;
    }

    public DateHistogramValuesSourceBuilder calendarInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.calendarInterval(interval);
        return this;
    }

    public DateHistogramValuesSourceBuilder fixedInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.fixedInterval(interval);
        return this;
    }

    public DateHistogramInterval getIntervalAsCalendar() {
        return this.dateHistogramInterval.getAsCalendarInterval();
    }

    public DateHistogramInterval getIntervalAsFixed() {
        return this.dateHistogramInterval.getAsFixedInterval();
    }

    public DateHistogramValuesSourceBuilder timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public ZoneId timeZone() {
        return this.timeZone;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramValuesSourceBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC), (valuesSourceConfig, rounding, name, hasScript, format, missingBucket, order) -> {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            Rounding.Prepared preparedRounding = rounding.prepareForUnknown();
            RoundingValuesSource vs = new RoundingValuesSource(numeric, preparedRounding);
            DocValueFormat docValueFormat = format == null ? DocValueFormat.RAW : valuesSourceConfig.format();
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            return new CompositeValuesSourceConfig(name, fieldType, vs, docValueFormat, order, missingBucket, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                RoundingValuesSource roundingValuesSource = (RoundingValuesSource)compositeValuesSourceConfig.valuesSource();
                return new LongValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), roundingValuesSource::longValues, roundingValuesSource::round, compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.DATE;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config) throws IOException {
        Rounding rounding = this.dateHistogramInterval.createRounding(this.timeZone(), this.offset);
        return queryShardContext.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config).apply(config, rounding, this.name, config.script() != null, this.format(), this.missingBucket(), this.order());
    }

    static {
        PARSER.declareString(CompositeValuesSourceBuilder::format, new ParseField("format", new String[0]));
        DateIntervalWrapper.declareIntervalFields(PARSER);
        PARSER.declareField(DateHistogramValuesSourceBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(DateHistogramValuesSourceBuilder::timeZone, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, new ParseField("time_zone", new String[0]), ObjectParser.ValueType.LONG);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface DateHistogramCompositeSupplier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, Rounding var2, String var3, boolean var4, String var5, boolean var6, SortOrder var7);
    }
}

