/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.script.mustache;

import com.github.mustachejava.reflect.ReflectionObjectHandler;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.easysearch.common.util.CollectionUtils;
import org.easysearch.common.util.iterable.Iterables;

final class CustomReflectionObjectHandler
extends ReflectionObjectHandler {
    CustomReflectionObjectHandler() {
    }

    public Object coerce(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return new ArrayMap(object);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return new CollectionMap(collection);
        }
        return super.coerce(object);
    }

    public String stringify(Object object) {
        CollectionUtils.ensureNoSelfReferences(object, "CustomReflectionObjectHandler stringify");
        return super.stringify(object);
    }

    static final class ArrayMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Object array;
        private final int length;

        ArrayMap(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public Object get(Object key) {
            if ("size".equals(key)) {
                return this.size();
            }
            if (key instanceof Number) {
                return Array.get(this.array, ((Number)key).intValue());
            }
            try {
                int index = Integer.parseInt(key.toString());
                return Array.get(this.array, index);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>(this.length);
            for (int i = 0; i < this.length; ++i) {
                map.put(i, Array.get(this.array, i));
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < length;
                }

                @Override
                public Object next() {
                    return Array.get(array, this.index++);
                }
            };
        }
    }

    static final class CollectionMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Collection<Object> col;

        CollectionMap(Collection<Object> col) {
            this.col = col;
        }

        @Override
        public Object get(Object key) {
            if ("size".equals(key)) {
                return this.col.size();
            }
            if (key instanceof Number) {
                return Iterables.get(this.col, ((Number)key).intValue());
            }
            try {
                int index = Integer.parseInt(key.toString());
                return Iterables.get(this.col, index);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>(this.col.size());
            int i = 0;
            for (Object item : this.col) {
                map.put(i++, item);
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.col.iterator();
        }
    }
}

