/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.ingest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.ingest.PutPipelineRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.collect.Tuple;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestPutPipelineAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_put_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple<XContentType, BytesReference> sourceTuple = restRequest.contentOrSourceParam();
        PutPipelineRequest request = new PutPipelineRequest(restRequest.param("id"), sourceTuple.v2(), sourceTuple.v1());
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        return channel -> client.admin().cluster().putPipeline(request, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

