/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.cat;

import java.util.Collections;
import java.util.List;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.cluster.state.ClusterStateRequest;
import org.easysearch.action.admin.cluster.state.ClusterStateResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.node.DiscoveryNodes;
import org.easysearch.common.Table;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.action.RestResponseListener;
import org.easysearch.rest.action.cat.AbstractCatAction;
import org.easysearch.rest.action.cat.RestTable;

public class RestMasterAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/master"));
    }

    @Override
    public String getName() {
        return "cat_master_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/master\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse clusterStateResponse) throws Exception {
                return RestTable.buildResponse(RestMasterAction.this.buildTable(request, clusterStateResponse), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address ").addCell("node", "alias:n;desc:node name").endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state) {
        Table table = this.getTableWithHeader(request);
        DiscoveryNodes nodes = state.getState().nodes();
        table.startRow();
        DiscoveryNode master = nodes.get(nodes.getMasterNodeId());
        if (master == null) {
            table.addCell("-");
            table.addCell("-");
            table.addCell("-");
            table.addCell("-");
        } else {
            table.addCell(master.getId());
            table.addCell(master.getHostName());
            table.addCell(master.getHostAddress());
            table.addCell(master.getName());
        }
        table.endRow();
        return table;
    }
}

