/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.EasysearchException;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;
import org.easysearch.common.breaker.CircuitBreaker;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.BytesStreamOutput;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.common.path.PathTrie;
import org.easysearch.common.util.concurrent.ThreadContext;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.core.internal.io.Streams;
import org.easysearch.http.HttpServerTransport;
import org.easysearch.indices.breaker.CircuitBreakerService;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.BytesRestResponse;
import org.easysearch.rest.DeprecationRestHandler;
import org.easysearch.rest.MethodHandlers;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestHeaderDefinition;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestResponse;
import org.easysearch.rest.RestStatus;
import org.easysearch.rest.RestUtils;
import org.easysearch.usage.UsageService;

public class RestController
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(RestController.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestController.class);
    private static final String ELASTIC_PRODUCT_ORIGIN_HTTP_HEADER = "X-elastic-product-origin";
    private static final BytesReference FAVICON_RESPONSE;
    private final PathTrie<MethodHandlers> handlers = new PathTrie(RestUtils.REST_DECODER);
    private final UnaryOperator<RestHandler> handlerWrapper;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final Set<RestHeaderDefinition> headersToCopy;
    private final UsageService usageService;

    public RestController(Set<RestHeaderDefinition> headersToCopy, UnaryOperator<RestHandler> handlerWrapper, NodeClient client, CircuitBreakerService circuitBreakerService, UsageService usageService) {
        this.headersToCopy = headersToCopy;
        this.usageService = usageService;
        if (handlerWrapper == null) {
            handlerWrapper = h -> h;
        }
        this.handlerWrapper = handlerWrapper;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        this.registerHandlerNoWrap(RestRequest.Method.GET, "/favicon.ico", (request, channel, clnt) -> channel.sendResponse(new BytesRestResponse(RestStatus.OK, "image/x-icon", FAVICON_RESPONSE)));
    }

    protected void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, deprecationLogger));
    }

    protected void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage);
    }

    protected void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        if (handler instanceof BaseRestHandler) {
            this.usageService.addRestHandler((BaseRestHandler)handler);
        }
        if (path.contains("plugins")) {
            logger.debug("RestController.registerHandler " + method + " " + path);
        }
        this.registerHandlerNoWrap(method, path, (RestHandler)this.handlerWrapper.apply(handler));
    }

    private void registerHandlerNoWrap(RestRequest.Method method, String path, RestHandler maybeWrappedHandler) {
        this.handlers.insertOrUpdate(path, new MethodHandlers(path, maybeWrappedHandler, method), (mHandlers, newMHandler) -> mHandlers.addMethods(maybeWrappedHandler, method));
    }

    public void registerHandler(RestHandler restHandler) {
        restHandler.routes().forEach(route -> this.registerHandler(route.getMethod(), route.getPath(), restHandler));
        restHandler.deprecatedRoutes().forEach(route -> this.registerAsDeprecatedHandler(route.getMethod(), route.getPath(), restHandler, route.getDeprecationMessage()));
        restHandler.replacedRoutes().forEach(route -> this.registerWithDeprecatedHandler(route.getMethod(), route.getPath(), restHandler, route.getDeprecatedMethod(), route.getDeprecatedPath()));
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        try {
            this.tryAllHandlers(request, channel, threadContext);
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
            }
        }
    }

    @Override
    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        try {
            Exception e = cause == null ? new EasysearchException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new EasysearchException(cause));
            channel.sendResponse(new BytesRestResponse(channel, RestStatus.BAD_REQUEST, e));
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void dispatchRequest(RestRequest request, RestChannel channel, RestHandler handler) throws Exception {
        int contentLength = request.content().length();
        if (contentLength > 0) {
            XContentType xContentType = request.getXContentType();
            if (xContentType == null) {
                this.sendContentTypeErrorMessage(request.getAllHeaderValues("Content-Type"), channel);
                return;
            }
            if (handler.supportsContentStream() && xContentType != XContentType.JSON && xContentType != XContentType.SMILE) {
                channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + xContentType + "] does not support stream parsing. Use JSON or SMILE instead"));
                return;
            }
        }
        RestChannel responseChannel = channel;
        try {
            if (handler.canTripCircuitBreaker()) {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
            } else {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
            if (!handler.allowsUnsafeBuffers()) {
                request.ensureSafeBuffers();
            }
            if (!handler.allowSystemIndexAccessByDefault() && request.header(ELASTIC_PRODUCT_ORIGIN_HTTP_HEADER) == null) {
                this.client.threadPool().getThreadContext().putHeader("_system_index_access_allowed", Boolean.FALSE.toString());
            }
            handler.handleRequest(request, responseChannel, this.client);
        }
        catch (Exception e) {
            responseChannel.sendResponse(new BytesRestResponse(responseChannel, e));
        }
    }

    private boolean handleNoHandlerFound(String rawPath, RestRequest.Method method, String uri, RestChannel channel) {
        Set<RestRequest.Method> validMethodSet = this.getValidHandlerMethodSet(rawPath);
        if (!validMethodSet.contains((Object)method)) {
            if (method == RestRequest.Method.OPTIONS) {
                this.handleOptionsRequest(channel, validMethodSet);
                return true;
            }
            if (!validMethodSet.isEmpty()) {
                this.handleUnsupportedHttpMethod(uri, method, channel, validMethodSet, null);
                return true;
            }
        }
        return false;
    }

    private void sendContentTypeErrorMessage(@Nullable List<String> contentTypeHeader, RestChannel channel) throws IOException {
        Object errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(contentTypeHeader) + "] is not supported";
        channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, (String)errorMessage));
    }

    private void tryAllHandlers(RestRequest request, RestChannel channel, ThreadContext threadContext) throws Exception {
        RestRequest.Method requestMethod;
        for (RestHeaderDefinition restHeader : this.headersToCopy) {
            String name = restHeader.getName();
            List<String> headerValues = request.getAllHeaderValues(name);
            if (headerValues == null || headerValues.isEmpty()) continue;
            List distinctHeaderValues = headerValues.stream().distinct().collect(Collectors.toList());
            if (!restHeader.isMultiValueAllowed() && distinctHeaderValues.size() > 1) {
                channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "multiple values for single-valued header [" + name + "]."));
                return;
            }
            threadContext.putHeader(name, String.join((CharSequence)",", distinctHeaderValues));
        }
        if (request.paramAsBoolean("error_trace", false) && !channel.detailedErrorsEnabled()) {
            channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "error traces in responses are disabled."));
            return;
        }
        String rawPath = request.rawPath();
        String uri = request.uri();
        try {
            requestMethod = request.method();
            Iterator<MethodHandlers> allHandlers = this.getAllHandlers(request.params(), rawPath);
            while (allHandlers.hasNext()) {
                MethodHandlers handlers = allHandlers.next();
                RestHandler handler = handlers == null ? null : handlers.getHandler(requestMethod);
                if (handler == null) {
                    if (!this.handleNoHandlerFound(rawPath, requestMethod, uri, channel)) continue;
                    return;
                }
                this.dispatchRequest(request, channel, handler);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.handleUnsupportedHttpMethod(uri, null, channel, this.getValidHandlerMethodSet(rawPath), e);
            return;
        }
        this.handleBadRequest(uri, requestMethod, channel);
    }

    Iterator<MethodHandlers> getAllHandlers(@Nullable Map<String, String> requestParamsRef, String rawPath) {
        Supplier<Map<String, String>> paramsSupplier;
        if (requestParamsRef == null) {
            paramsSupplier = () -> null;
        } else {
            HashMap<String, String> originalParams = new HashMap<String, String>(requestParamsRef);
            paramsSupplier = () -> {
                requestParamsRef.clear();
                requestParamsRef.putAll(originalParams);
                return requestParamsRef;
            };
        }
        return this.handlers.retrieveAll(rawPath, paramsSupplier);
    }

    private void handleUnsupportedHttpMethod(String uri, @Nullable RestRequest.Method method, RestChannel channel, Set<RestRequest.Method> validMethodSet, @Nullable IllegalArgumentException exception) {
        try {
            StringBuilder msg = new StringBuilder();
            if (exception == null) {
                msg.append("Incorrect HTTP method for uri [").append(uri);
                msg.append("] and method [").append((Object)method).append("]");
            } else {
                msg.append(exception.getMessage());
            }
            if (!validMethodSet.isEmpty()) {
                msg.append(", allowed: ").append(validMethodSet);
            }
            BytesRestResponse bytesRestResponse = BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.METHOD_NOT_ALLOWED, msg.toString());
            if (!validMethodSet.isEmpty()) {
                bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
            }
            channel.sendResponse(bytesRestResponse);
        }
        catch (IOException e) {
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void handleOptionsRequest(RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
        if (!validMethodSet.isEmpty()) {
            bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
        }
        channel.sendResponse(bytesRestResponse);
    }

    private void handleBadRequest(String uri, RestRequest.Method method, RestChannel channel) throws IOException {
        try (XContentBuilder builder = channel.newErrorBuilder();){
            builder.startObject();
            builder.field("error", "no handler found for uri [" + uri + "] and method [" + method + "]");
            builder.endObject();
            channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
        }
    }

    private Set<RestRequest.Method> getValidHandlerMethodSet(String rawPath) {
        HashSet<RestRequest.Method> validMethods = new HashSet<RestRequest.Method>();
        Iterator<MethodHandlers> allHandlers = this.getAllHandlers(null, rawPath);
        while (allHandlers.hasNext()) {
            MethodHandlers methodHandlers = allHandlers.next();
            if (methodHandlers == null) continue;
            validMethods.addAll(methodHandlers.getValidMethods());
        }
        return validMethods;
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    static {
        try (InputStream stream = RestController.class.getResourceAsStream("/config/favicon.ico");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy(stream, out);
            FAVICON_RESPONSE = new BytesArray(out.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable XContentType xContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, useFiltering);
        }

        @Override
        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, responseContentType, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }
}

