/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest;

import java.util.Objects;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.common.logging.DeprecationLogger;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;

public class DeprecationRestHandler
implements RestHandler {
    private final RestHandler handler;
    private final String deprecationMessage;
    private final DeprecationLogger deprecationLogger;

    public DeprecationRestHandler(RestHandler handler, String deprecationMessage, DeprecationLogger deprecationLogger) {
        this.handler = Objects.requireNonNull(handler);
        this.deprecationMessage = DeprecationRestHandler.requireValidHeader(deprecationMessage);
        this.deprecationLogger = Objects.requireNonNull(deprecationLogger);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.deprecationLogger.deprecate("deprecated_route", this.deprecationMessage, new Object[0]);
        this.handler.handleRequest(request, channel, client);
    }

    @Override
    public boolean supportsContentStream() {
        return this.handler.supportsContentStream();
    }

    public static boolean validHeaderValue(String value) {
        if (!Strings.hasText(value)) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String requireValidHeader(String value) {
        if (!DeprecationRestHandler.validHeaderValue(value)) {
            throw new IllegalArgumentException("header value must contain only US ASCII text");
        }
        return value;
    }
}

