/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.repositories.blobstore;

import java.util.Map;
import org.easysearch.cluster.metadata.RepositoryMetadata;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.UUIDs;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.indices.recovery.RecoverySettings;
import org.easysearch.repositories.RepositoryInfo;
import org.easysearch.repositories.RepositoryStatsSnapshot;
import org.easysearch.repositories.blobstore.BlobStoreRepository;
import org.easysearch.threadpool.ThreadPool;

public abstract class MeteredBlobStoreRepository
extends BlobStoreRepository {
    private final RepositoryInfo repositoryInfo;

    public MeteredBlobStoreRepository(RepositoryMetadata metadata, boolean compress, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings, Map<String, String> location) {
        super(metadata, compress, namedXContentRegistry, clusterService, recoverySettings);
        ThreadPool threadPool = clusterService.getClusterApplierService().threadPool();
        this.repositoryInfo = new RepositoryInfo(UUIDs.randomBase64UUID(), metadata.name(), metadata.type(), location, threadPool.absoluteTimeInMillis());
    }

    public RepositoryStatsSnapshot statsSnapshot() {
        return new RepositoryStatsSnapshot(this.repositoryInfo, this.stats(), -1L, false);
    }

    public RepositoryStatsSnapshot statsSnapshotForArchival(long clusterVersion) {
        RepositoryInfo stoppedRepoInfo = this.repositoryInfo.stopped(this.threadPool.absoluteTimeInMillis());
        return new RepositoryStatsSnapshot(stoppedRepoInfo, this.stats(), clusterVersion, true);
    }
}

