/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.persistent;

import org.easysearch.common.Nullable;
import org.easysearch.common.util.concurrent.AbstractRunnable;
import org.easysearch.persistent.AllocatedPersistentTask;
import org.easysearch.persistent.PersistentTaskParams;
import org.easysearch.persistent.PersistentTaskState;
import org.easysearch.persistent.PersistentTasksExecutor;
import org.easysearch.threadpool.ThreadPool;

public class NodePersistentTasksExecutor {
    private final ThreadPool threadPool;

    NodePersistentTasksExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void executeTask(final Params params, final @Nullable PersistentTaskState state, final AllocatedPersistentTask task, final PersistentTasksExecutor<Params> executor) {
        this.threadPool.executor(executor.getExecutor()).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                task.markAsFailed(e);
            }

            @Override
            protected void doRun() throws Exception {
                try {
                    executor.nodeOperation(task, params, state);
                }
                catch (Exception ex) {
                    task.markAsFailed(ex);
                }
            }
        });
    }
}

