/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.monitor;

import java.io.IOException;
import org.easysearch.common.component.AbstractLifecycleComponent;
import org.easysearch.common.settings.Settings;
import org.easysearch.env.NodeEnvironment;
import org.easysearch.monitor.fs.FsService;
import org.easysearch.monitor.jvm.JvmGcMonitorService;
import org.easysearch.monitor.jvm.JvmService;
import org.easysearch.monitor.os.OsService;
import org.easysearch.monitor.process.ProcessService;
import org.easysearch.threadpool.ThreadPool;

public class MonitorService
extends AbstractLifecycleComponent {
    private final JvmGcMonitorService jvmGcMonitorService;
    private final OsService osService;
    private final ProcessService processService;
    private final JvmService jvmService;
    private final FsService fsService;

    public MonitorService(Settings settings, NodeEnvironment nodeEnvironment, ThreadPool threadPool) throws IOException {
        this.jvmGcMonitorService = new JvmGcMonitorService(settings, threadPool);
        this.osService = new OsService(settings);
        this.processService = new ProcessService(settings);
        this.jvmService = new JvmService(settings);
        this.fsService = new FsService(settings, nodeEnvironment);
    }

    public OsService osService() {
        return this.osService;
    }

    public ProcessService processService() {
        return this.processService;
    }

    public JvmService jvmService() {
        return this.jvmService;
    }

    public FsService fsService() {
        return this.fsService;
    }

    @Override
    protected void doStart() {
        this.jvmGcMonitorService.start();
    }

    @Override
    protected void doStop() {
        this.jvmGcMonitorService.stop();
    }

    @Override
    protected void doClose() {
        this.jvmGcMonitorService.close();
    }
}

