/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.easysearch.client.Client;
import org.easysearch.common.util.concurrent.ThreadContext;
import org.easysearch.env.Environment;
import org.easysearch.index.analysis.AnalysisRegistry;
import org.easysearch.ingest.IngestDocument;
import org.easysearch.ingest.IngestService;
import org.easysearch.script.ScriptService;
import org.easysearch.threadpool.Scheduler;

public interface Processor {
    default public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        IngestDocument result;
        try {
            result = this.execute(ingestDocument);
        }
        catch (Exception e) {
            handler.accept(null, e);
            return;
        }
        handler.accept(result, null);
    }

    public IngestDocument execute(IngestDocument var1) throws Exception;

    public String getType();

    public String getTag();

    public String getDescription();

    public static class Parameters {
        public final Environment env;
        public final ScriptService scriptService;
        public final AnalysisRegistry analysisRegistry;
        public final ThreadContext threadContext;
        public final LongSupplier relativeTimeSupplier;
        public final IngestService ingestService;
        public final Consumer<Runnable> genericExecutor;
        public final BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler;
        public final Client client;

        public Parameters(Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, ThreadContext threadContext, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler, IngestService ingestService, Client client, Consumer<Runnable> genericExecutor) {
            this.env = env;
            this.scriptService = scriptService;
            this.threadContext = threadContext;
            this.analysisRegistry = analysisRegistry;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
            this.ingestService = ingestService;
            this.client = client;
            this.genericExecutor = genericExecutor;
        }
    }

    public static interface Factory {
        public Processor create(Map<String, Factory> var1, String var2, String var3, Map<String, Object> var4) throws Exception;
    }
}

