/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.indices;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.common.Nullable;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

public class TermsLookup
implements Writeable,
ToXContentFragment {
    private final String index;
    @Nullable
    private String type;
    private final String id;
    private final String path;
    private String routing;
    private static final ConstructingObjectParser<TermsLookup, Void> PARSER = new ConstructingObjectParser("terms_lookup", args -> {
        String index = (String)args[0];
        String type = (String)args[1];
        String id = (String)args[2];
        String path = (String)args[3];
        return new TermsLookup(index, type, id, path);
    });

    public TermsLookup(String index, String id, String path) {
        this(index, null, id, path);
    }

    @Deprecated
    public TermsLookup(String index, String type, String id, String path) {
        if (id == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the id.");
        }
        if (path == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the path.");
        }
        if (index == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the index.");
        }
        this.index = index;
        this.type = type;
        this.id = id;
        this.path = path;
    }

    public TermsLookup(StreamInput in) throws IOException {
        this.type = in.readOptionalString();
        this.id = in.readString();
        this.path = in.readString();
        this.index = in.readString();
        this.routing = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        out.writeString(this.path);
        out.writeString(this.index);
        out.writeOptionalString(this.routing);
    }

    public String index() {
        return this.index;
    }

    @Deprecated
    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    public String routing() {
        return this.routing;
    }

    public TermsLookup routing(String routing) {
        this.routing = routing;
        return this;
    }

    public static TermsLookup parseTermsLookup(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String toString() {
        if (this.type == null) {
            return this.index + "/" + this.id + "/" + this.path;
        }
        return this.index + "/" + this.type + "/" + this.id + "/" + this.path;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index", this.index);
        if (this.type != null) {
            builder.field("type", this.type);
        }
        builder.field("id", this.id);
        builder.field("path", this.path);
        if (this.routing != null) {
            builder.field("routing", this.routing);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.id, this.path, this.routing);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsLookup other = (TermsLookup)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.routing, other.routing);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("type", new String[0]).withAllDeprecated());
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("path", new String[0]));
        PARSER.declareString(TermsLookup::routing, new ParseField("routing", new String[0]));
    }
}

