/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.similarity;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;
import org.easysearch.script.SimilarityScript;
import org.easysearch.script.SimilarityWeightScript;

public final class ScriptedSimilarity
extends Similarity {
    final String weightScriptSource;
    final String scriptSource;
    final SimilarityWeightScript.Factory weightScriptFactory;
    final SimilarityScript.Factory scriptFactory;
    final boolean discountOverlaps;

    public ScriptedSimilarity(String weightScriptString, SimilarityWeightScript.Factory weightScriptFactory, String scriptString, SimilarityScript.Factory scriptFactory, boolean discountOverlaps) {
        this.weightScriptSource = weightScriptString;
        this.weightScriptFactory = weightScriptFactory;
        this.scriptSource = scriptString;
        this.scriptFactory = scriptFactory;
        this.discountOverlaps = discountOverlaps;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(weightScript=[" + this.weightScriptSource + "], script=[" + this.scriptSource + "])";
    }

    public long computeNorm(FieldInvertState state) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        return SmallFloat.intToByte4((int)numTerms);
    }

    private double computeWeight(Query query, Field field, Term term) {
        if (this.weightScriptFactory == null) {
            return 1.0;
        }
        SimilarityWeightScript weightScript = this.weightScriptFactory.newInstance();
        return weightScript.execute(query, field, term);
    }

    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        final Query query = new Query(boost);
        long docCount = collectionStats.docCount();
        if (docCount == -1L) {
            docCount = collectionStats.maxDoc();
        }
        final Field field = new Field(docCount, collectionStats.sumDocFreq(), collectionStats.sumTotalTermFreq());
        Term[] terms = new Term[termStats.length];
        for (int i = 0; i < termStats.length; ++i) {
            terms[i] = new Term(termStats[i].docFreq(), termStats[i].totalTermFreq());
        }
        final Similarity.SimScorer[] scorers = new Similarity.SimScorer[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            final Term term = terms[i];
            final SimilarityScript script = this.scriptFactory.newInstance();
            final Doc doc = new Doc();
            final double scoreWeight = this.computeWeight(query, field, term);
            scorers[i] = new Similarity.SimScorer(){

                public float score(float freq, long norm) {
                    doc.freq = freq;
                    doc.norm = norm;
                    return (float)script.execute(scoreWeight, query, field, term, doc);
                }

                public Explanation explain(Explanation freq, long norm) {
                    float score = this.score(freq.getValue().floatValue(), norm);
                    return Explanation.match((Number)Float.valueOf(score), (String)("score from " + ScriptedSimilarity.this.toString() + " computed from:"), (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf((float)scoreWeight), (String)"weight", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(query.boost), (String)"query.boost", (Explanation[])new Explanation[0]), Explanation.match((Number)field.docCount, (String)"field.docCount", (Explanation[])new Explanation[0]), Explanation.match((Number)field.sumDocFreq, (String)"field.sumDocFreq", (Explanation[])new Explanation[0]), Explanation.match((Number)field.sumTotalTermFreq, (String)"field.sumTotalTermFreq", (Explanation[])new Explanation[0]), Explanation.match((Number)term.docFreq, (String)"term.docFreq", (Explanation[])new Explanation[0]), Explanation.match((Number)term.totalTermFreq, (String)"term.totalTermFreq", (Explanation[])new Explanation[0]), Explanation.match((Number)freq.getValue(), (String)"doc.freq", (Explanation[])freq.getDetails()), Explanation.match((Number)doc.getLength(), (String)"doc.length", (Explanation[])new Explanation[0])});
                }
            };
        }
        if (scorers.length == 1) {
            return scorers[0];
        }
        return new Similarity.SimScorer(){

            public float score(float freq, long norm) {
                double sum = 0.0;
                for (Similarity.SimScorer scorer : scorers) {
                    sum += (double)scorer.score(freq, norm);
                }
                return (float)sum;
            }

            public Explanation explain(Explanation freq, long norm) {
                Explanation[] subs = new Explanation[scorers.length];
                for (int i = 0; i < subs.length; ++i) {
                    subs[i] = scorers[i].explain(freq, norm);
                }
                return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), (String)"Sum of:", (Explanation[])subs);
            }
        };
    }

    public static class Query {
        private final float boost;

        private Query(float boost) {
            this.boost = boost;
        }

        public float getBoost() {
            return this.boost;
        }
    }

    public static class Field {
        private final long docCount;
        private final long sumDocFreq;
        private final long sumTotalTermFreq;

        private Field(long docCount, long sumDocFreq, long sumTotalTermFreq) {
            this.docCount = docCount;
            this.sumDocFreq = sumDocFreq;
            this.sumTotalTermFreq = sumTotalTermFreq;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }
    }

    public static class Term {
        private final long docFreq;
        private final long totalTermFreq;

        private Term(long docFreq, long totalTermFreq) {
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }

        public long getDocFreq() {
            return this.docFreq;
        }

        public long getTotalTermFreq() {
            return this.totalTermFreq;
        }
    }

    public static class Doc {
        private float freq;
        private long norm;

        private Doc() {
        }

        public int getLength() {
            return SmallFloat.byte4ToInt((byte)((byte)this.norm));
        }

        public float getFreq() {
            return this.freq;
        }
    }
}

