/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.shard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.easysearch.common.collect.MapBuilder;
import org.easysearch.common.metrics.CounterMetric;
import org.easysearch.common.metrics.MeanMetric;
import org.easysearch.common.regex.Regex;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.shard.IndexingOperationListener;
import org.easysearch.index.shard.IndexingStats;
import org.easysearch.index.shard.ShardId;

final class InternalIndexingStats
implements IndexingOperationListener {
    private final StatsHolder totalStats = new StatsHolder();
    private volatile Map<String, StatsHolder> typesStats = Collections.emptyMap();

    InternalIndexingStats() {
    }

    IndexingStats stats(boolean isThrottled, long currentThrottleInMillis, String ... types) {
        HashMap<String, IndexingStats.Stats> typesSt;
        IndexingStats.Stats total;
        block4: {
            total = this.totalStats.stats(isThrottled, currentThrottleInMillis);
            typesSt = null;
            if (types == null || types.length <= 0) break block4;
            typesSt = new HashMap<String, IndexingStats.Stats>(this.typesStats.size());
            if (types.length == 1 && types[0].equals("_all")) {
                for (Map.Entry<String, StatsHolder> entry : this.typesStats.entrySet()) {
                    typesSt.put(entry.getKey(), entry.getValue().stats(isThrottled, currentThrottleInMillis));
                }
            } else {
                for (Map.Entry<String, StatsHolder> entry : this.typesStats.entrySet()) {
                    if (!Regex.simpleMatch(types, entry.getKey())) continue;
                    typesSt.put(entry.getKey(), entry.getValue().stats(isThrottled, currentThrottleInMillis));
                }
            }
        }
        return new IndexingStats(total, typesSt);
    }

    @Override
    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (!operation.origin().isRecovery()) {
            this.totalStats.indexCurrent.inc();
            this.typeStats((String)operation.type()).indexCurrent.inc();
        }
        return operation;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (index.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.indexMetric.inc(took);
                this.totalStats.indexCurrent.dec();
                StatsHolder typeStats = this.typeStats(index.type());
                typeStats.indexMetric.inc(took);
                typeStats.indexCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postIndex(shardId, index, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + result.getResultType());
            }
        }
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (!index.origin().isRecovery()) {
            this.totalStats.indexCurrent.dec();
            this.typeStats((String)index.type()).indexCurrent.dec();
            this.totalStats.indexFailed.inc();
            this.typeStats((String)index.type()).indexFailed.inc();
        }
    }

    @Override
    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.inc();
            this.typeStats((String)delete.type()).deleteCurrent.inc();
        }
        return delete;
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (delete.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.deleteMetric.inc(took);
                this.totalStats.deleteCurrent.dec();
                StatsHolder typeStats = this.typeStats(delete.type());
                typeStats.deleteMetric.inc(took);
                typeStats.deleteCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postDelete(shardId, delete, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + result.getResultType());
            }
        }
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.dec();
            this.typeStats((String)delete.type()).deleteCurrent.dec();
        }
    }

    public void noopUpdate(String type) {
        this.totalStats.noopUpdates.inc();
        this.typeStats((String)type).noopUpdates.inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder typeStats(String type) {
        StatsHolder stats = this.typesStats.get(type);
        if (stats == null) {
            InternalIndexingStats internalIndexingStats = this;
            synchronized (internalIndexingStats) {
                stats = this.typesStats.get(type);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.typesStats = MapBuilder.newMapBuilder(this.typesStats).put(type, stats).immutableMap();
                }
            }
        }
        return stats;
    }

    static class StatsHolder {
        private final MeanMetric indexMetric = new MeanMetric();
        private final MeanMetric deleteMetric = new MeanMetric();
        private final CounterMetric indexCurrent = new CounterMetric();
        private final CounterMetric indexFailed = new CounterMetric();
        private final CounterMetric deleteCurrent = new CounterMetric();
        private final CounterMetric noopUpdates = new CounterMetric();

        StatsHolder() {
        }

        IndexingStats.Stats stats(boolean isThrottled, long currentThrottleMillis) {
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.indexMetric.sum()), this.indexCurrent.count(), this.indexFailed.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count(), this.noopUpdates.count(), isThrottled, TimeUnit.MILLISECONDS.toMillis(currentThrottleMillis));
        }
    }
}

