/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.rankeval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchType;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.rankeval.RankEvalSpec;

public class RankEvalRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private RankEvalSpec rankingEvaluationSpec;
    private IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
    private String[] indices = Strings.EMPTY_ARRAY;
    private SearchType searchType = SearchType.DEFAULT;

    public RankEvalRequest(RankEvalSpec rankingEvaluationSpec, String[] indices) {
        this.rankingEvaluationSpec = Objects.requireNonNull(rankingEvaluationSpec, "ranking evaluation specification must not be null");
        this.indices(indices);
    }

    RankEvalRequest(StreamInput in) throws IOException {
        super(in);
        this.rankingEvaluationSpec = new RankEvalSpec(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.searchType = SearchType.fromId(in.readByte());
    }

    RankEvalRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = null;
        if (this.rankingEvaluationSpec == null) {
            e = new ActionRequestValidationException();
            e.addValidationError("missing ranking evaluation specification");
        }
        return e;
    }

    public RankEvalSpec getRankEvalSpec() {
        return this.rankingEvaluationSpec;
    }

    public void setRankEvalSpec(RankEvalSpec task) {
        this.rankingEvaluationSpec = task;
    }

    @Override
    public RankEvalRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
    }

    public void searchType(SearchType searchType) {
        this.searchType = Objects.requireNonNull(searchType, "searchType must not be null");
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.rankingEvaluationSpec.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeByte(this.searchType.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankEvalRequest that = (RankEvalRequest)o;
        return Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.rankingEvaluationSpec, that.rankingEvaluationSpec) && Objects.equals((Object)this.searchType, (Object)that.searchType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indicesOptions, Arrays.hashCode(this.indices), this.rankingEvaluationSpec, this.searchType});
    }
}

