/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.query;

import java.util.ArrayList;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.easysearch.common.geo.GeoPolygonDecomposer;
import org.easysearch.common.geo.GeoShapeType;
import org.easysearch.common.geo.GeoShapeUtils;
import org.easysearch.common.geo.ShapeRelation;
import org.easysearch.geometry.Circle;
import org.easysearch.geometry.Geometry;
import org.easysearch.geometry.GeometryCollection;
import org.easysearch.geometry.GeometryVisitor;
import org.easysearch.geometry.Line;
import org.easysearch.geometry.LinearRing;
import org.easysearch.geometry.MultiLine;
import org.easysearch.geometry.MultiPoint;
import org.easysearch.geometry.MultiPolygon;
import org.easysearch.geometry.Point;
import org.easysearch.geometry.Polygon;
import org.easysearch.geometry.Rectangle;
import org.easysearch.geometry.ShapeType;
import org.easysearch.index.mapper.GeoPointFieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.query.QueryShardException;

public class VectorGeoPointShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsGeoPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsGeoPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "Expected geo_point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(context, fieldName, relation);
        return queryShape.visit(shapeVisitor);
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        @Override
        public Query visit(Circle circle) {
            Query query = LatLonPoint.newDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add(shape.visit(this), occur);
            }
        }

        @Override
        public Query visit(Line line) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.LINESTRING + " queries", new Object[0]);
        }

        @Override
        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.LINEARRING + " queries", new Object[0]);
        }

        @Override
        public Query visit(MultiLine multiLine) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.MULTILINESTRING + " queries", new Object[0]);
        }

        @Override
        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.MULTIPOINT + " queries", new Object[0]);
        }

        @Override
        private Query visit(ArrayList<Polygon> collector) {
            org.apache.lucene.geo.Polygon[] lucenePolygons = new org.apache.lucene.geo.Polygon[collector.size()];
            for (int i = 0; i < collector.size(); ++i) {
                lucenePolygons[i] = GeoShapeUtils.toLucenePolygon(collector.get(i));
            }
            Query query = LatLonPoint.newPolygonQuery((String)this.fieldName, (org.apache.lucene.geo.Polygon[])lucenePolygons);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowPolygonQuery((String)this.fieldName, (org.apache.lucene.geo.Polygon[])lucenePolygons);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public Query visit(MultiPolygon multiPolygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
            return this.visit(collector);
        }

        @Override
        public Query visit(Point point) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.POINT + " queries", new Object[0]);
        }

        @Override
        public Query visit(Polygon polygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
            return this.visit(collector);
        }

        @Override
        public Query visit(Rectangle r) {
            Query query = LatLonPoint.newBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
    }
}

