/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.easysearch.common.Strings;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.plain.ConstantIndexFieldData;
import org.easysearch.index.mapper.ConstantFieldType;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.lookup.SearchLookup;

public class IndexFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new IndexFieldMapper());

    public IndexFieldMapper() {
        super(IndexFieldType.INSTANCE);
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    static final class IndexFieldType
    extends ConstantFieldType {
        static final IndexFieldType INSTANCE = new IndexFieldType();

        private IndexFieldType() {
            super("_index", Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_index";
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            if (caseInsensitive) {
                pattern = Strings.toLowercaseAscii(pattern);
            }
            return context.indexMatches(pattern);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(fullyQualifiedIndexName, this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }
}

