/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.easysearch.common.lease.Releasable;
import org.easysearch.common.util.concurrent.ConcurrentCollections;
import org.easysearch.common.util.concurrent.KeyedLock;
import org.easysearch.index.engine.DeleteVersionValue;
import org.easysearch.index.engine.IndexVersionValue;
import org.easysearch.index.engine.VersionValue;

final class LiveVersionMap
implements ReferenceManager.RefreshListener,
Accountable {
    private final KeyedLock<BytesRef> keyedLock = new KeyedLock();
    private final Map<BytesRef, DeleteVersionValue> tombstones = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private volatile Maps maps = new Maps();
    private volatile Maps unsafeKeysMap = new Maps();
    private static final long BASE_BYTES_PER_BYTESREF = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 3L;
    private static final long BASE_BYTES_PER_CHM_ENTRY;
    private final AtomicLong ramBytesUsedTombstones = new AtomicLong();

    LiveVersionMap() {
    }

    public void beforeRefresh() throws IOException {
        this.maps = this.maps.buildTransitionMap();
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.buildTransitionMap()) != null);
    }

    public void afterRefresh(boolean didRefresh) throws IOException {
        this.maps = this.maps.invalidateOldMap();
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.invalidateOldMap()) != null);
    }

    VersionValue getUnderLock(BytesRef uid) {
        return this.getUnderLock(uid, this.maps);
    }

    private VersionValue getUnderLock(BytesRef uid, Maps currentMaps) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        VersionValue value = currentMaps.current.get(uid);
        if (value != null) {
            return value;
        }
        value = currentMaps.old.get(uid);
        if (value != null) {
            return value;
        }
        return this.tombstones.get(uid);
    }

    VersionValue getVersionForAssert(BytesRef uid) {
        VersionValue value = this.getUnderLock(uid, this.maps);
        if (value == null) {
            value = this.getUnderLock(uid, this.unsafeKeysMap);
        }
        return value;
    }

    boolean isUnsafe() {
        return this.maps.current.isUnsafe() || this.maps.old.isUnsafe();
    }

    void enforceSafeAccess() {
        this.maps.needsSafeAccess = true;
    }

    boolean isSafeAccessRequired() {
        return this.maps.isSafeAccessMode();
    }

    void maybePutIndexUnderLock(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        Maps maps = this.maps;
        if (maps.isSafeAccessMode()) {
            this.putIndexUnderLock(uid, version);
        } else {
            this.removeTombstoneUnderLock(uid);
            maps.current.markAsUnsafe();
            assert (this.putAssertionMap(uid, version));
        }
    }

    void putIndexUnderLock(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.maps.put(uid, version);
        this.removeTombstoneUnderLock(uid);
    }

    private boolean putAssertionMap(BytesRef uid, IndexVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.unsafeKeysMap.put(uid, version);
        return true;
    }

    void putDeleteUnderLock(BytesRef uid, DeleteVersionValue version) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.putTombstone(uid, version);
        this.maps.remove(uid, version);
    }

    private void putTombstone(BytesRef uid, DeleteVersionValue version) {
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prevTombstone = this.tombstones.put(uid, version);
        long accountRam = BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRAMBytesUsed;
        if (prevTombstone != null) {
            accountRam -= BASE_BYTES_PER_CHM_ENTRY + prevTombstone.ramBytesUsed() + uidRAMBytesUsed;
        }
        if (accountRam != 0L) {
            long v = this.ramBytesUsedTombstones.addAndGet(accountRam);
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    void removeTombstoneUnderLock(BytesRef uid) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = this.tombstones.remove(uid);
        if (prev != null) {
            assert (prev.isDelete());
            long v = this.ramBytesUsedTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prev.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    private boolean canRemoveTombstone(long maxTimestampToPrune, long maxSeqNoToPrune, DeleteVersionValue versionValue) {
        boolean isTooOld = versionValue.time < maxTimestampToPrune;
        boolean isSafeToPrune = versionValue.seqNo <= maxSeqNoToPrune;
        boolean isNotTrackedByCurrentMaps = versionValue.time < this.maps.getMinDeleteTimestamp();
        return isTooOld && isSafeToPrune && isNotTrackedByCurrentMaps;
    }

    void pruneTombstones(long maxTimestampToPrune, long maxSeqNoToPrune) {
        for (Map.Entry<BytesRef, DeleteVersionValue> entry : this.tombstones.entrySet()) {
            if (!this.canRemoveTombstone(maxTimestampToPrune, maxSeqNoToPrune, entry.getValue())) continue;
            BytesRef uid = entry.getKey();
            Releasable lock = this.keyedLock.tryAcquire(uid);
            try {
                DeleteVersionValue versionValue;
                if (lock == null || (versionValue = this.tombstones.get(uid)) == null || !this.canRemoveTombstone(maxTimestampToPrune, maxSeqNoToPrune, versionValue)) continue;
                this.removeTombstoneUnderLock(uid);
            }
            finally {
                if (lock == null) continue;
                lock.close();
            }
        }
    }

    synchronized void clear() {
        this.maps = new Maps();
        this.tombstones.clear();
    }

    public long ramBytesUsed() {
        return this.maps.current.ramBytesUsed.get() + this.ramBytesUsedTombstones.get();
    }

    long ramBytesUsedForRefresh() {
        return this.maps.current.ramBytesUsed.get();
    }

    long getRefreshingBytes() {
        return this.maps.old.ramBytesUsed.get();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    Map<BytesRef, VersionValue> getAllCurrent() {
        return this.maps.current.map;
    }

    Map<BytesRef, DeleteVersionValue> getAllTombstones() {
        return this.tombstones;
    }

    Releasable acquireLock(BytesRef uid) {
        return this.keyedLock.acquire(uid);
    }

    boolean assertKeyedLockHeldByCurrentThread(BytesRef uid) {
        assert (this.keyedLock.isHeldByCurrentThread(uid)) : "Thread [" + Thread.currentThread().getName() + "], uid [" + uid.utf8ToString() + "]";
        return true;
    }

    static {
        ConcurrentMap<Integer, Integer> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        map.put(0, 0);
        long chmEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_BYTES_PER_CHM_ENTRY = chmEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    private static final class Maps {
        final VersionLookup current;
        final VersionLookup old;
        boolean needsSafeAccess;
        final boolean previousMapsNeededSafeAccess;

        Maps(VersionLookup current, VersionLookup old, boolean previousMapsNeededSafeAccess) {
            this.current = current;
            this.old = old;
            this.previousMapsNeededSafeAccess = previousMapsNeededSafeAccess;
        }

        Maps() {
            this(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency()), VersionLookup.EMPTY, false);
        }

        boolean isSafeAccessMode() {
            return this.needsSafeAccess || this.previousMapsNeededSafeAccess;
        }

        boolean shouldInheritSafeAccess() {
            boolean mapHasNotSeenAnyOperations = this.current.isEmpty() && !this.current.isUnsafe();
            return this.needsSafeAccess || mapHasNotSeenAnyOperations && this.previousMapsNeededSafeAccess;
        }

        Maps buildTransitionMap() {
            return new Maps(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(this.current.size())), this.current, this.shouldInheritSafeAccess());
        }

        Maps invalidateOldMap() {
            return new Maps(this.current, VersionLookup.EMPTY, this.previousMapsNeededSafeAccess);
        }

        void put(BytesRef uid, VersionValue version) {
            long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
            long ramAccounting = BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRAMBytesUsed;
            VersionValue previousValue = this.current.put(uid, version);
            this.adjustRam(ramAccounting += previousValue == null ? 0L : -(BASE_BYTES_PER_CHM_ENTRY + previousValue.ramBytesUsed() + uidRAMBytesUsed));
        }

        void adjustRam(long value) {
            if (value != 0L) {
                long v = this.current.ramBytesUsed.addAndGet(value);
                assert (v >= 0L) : "bytes=" + v;
            }
        }

        void remove(BytesRef uid, DeleteVersionValue deleted) {
            VersionValue previousValue = this.current.remove(uid);
            this.current.updateMinDeletedTimestamp(deleted);
            if (previousValue != null) {
                long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
                this.adjustRam(-(BASE_BYTES_PER_CHM_ENTRY + previousValue.ramBytesUsed() + uidRAMBytesUsed));
            }
            if (this.old != VersionLookup.EMPTY) {
                this.old.remove(uid);
            }
        }

        long getMinDeleteTimestamp() {
            return Math.min(this.current.minDeleteTimestamp.get(), this.old.minDeleteTimestamp.get());
        }
    }

    private static final class VersionLookup {
        final AtomicLong ramBytesUsed = new AtomicLong();
        private static final VersionLookup EMPTY = new VersionLookup(Collections.emptyMap());
        private final Map<BytesRef, VersionValue> map;
        private boolean unsafe;
        private final AtomicLong minDeleteTimestamp = new AtomicLong(Long.MAX_VALUE);

        private VersionLookup(Map<BytesRef, VersionValue> map) {
            this.map = map;
        }

        VersionValue get(BytesRef key) {
            return this.map.get(key);
        }

        VersionValue put(BytesRef key, VersionValue value) {
            return this.map.put(key, value);
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        int size() {
            return this.map.size();
        }

        boolean isUnsafe() {
            return this.unsafe;
        }

        void markAsUnsafe() {
            this.unsafe = true;
        }

        public VersionValue remove(BytesRef uid) {
            return this.map.remove(uid);
        }

        public void updateMinDeletedTimestamp(DeleteVersionValue delete) {
            long time = delete.time;
            this.minDeleteTimestamp.updateAndGet(prev -> Math.min(time, prev));
        }
    }
}

