/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.similarities.Similarity;
import org.easysearch.common.Nullable;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.codec.CodecService;
import org.easysearch.index.codec.CodecServiceConfig;
import org.easysearch.index.codec.CodecServiceFactory;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.engine.EngineConfig;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.seqno.RetentionLeases;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.store.Store;
import org.easysearch.index.translog.TranslogConfig;
import org.easysearch.index.translog.TranslogDeletionPolicyFactory;
import org.easysearch.indices.breaker.CircuitBreakerService;
import org.easysearch.plugins.EnginePlugin;
import org.easysearch.plugins.PluginsService;
import org.easysearch.threadpool.ThreadPool;

public class EngineConfigFactory {
    private final CodecServiceFactory codecServiceFactory;
    private final TranslogDeletionPolicyFactory translogDeletionPolicyFactory;

    public EngineConfigFactory(IndexSettings idxSettings) {
        this(Collections.emptyList(), idxSettings);
    }

    public EngineConfigFactory(PluginsService pluginsService, IndexSettings idxSettings) {
        this(pluginsService.filterPlugins(EnginePlugin.class), idxSettings);
    }

    EngineConfigFactory(Collection<EnginePlugin> enginePlugins, IndexSettings idxSettings) {
        Optional<Object> codecService = Optional.empty();
        String codecServiceOverridingPlugin = null;
        Optional<Object> codecServiceFactory = Optional.empty();
        String codecServiceFactoryOverridingPlugin = null;
        Optional<TranslogDeletionPolicyFactory> translogDeletionPolicyFactory = Optional.empty();
        String translogDeletionPolicyOverridingPlugin = null;
        for (EnginePlugin enginePlugin : enginePlugins) {
            if (!codecService.isPresent()) {
                codecService = enginePlugin.getCustomCodecService(idxSettings);
                codecServiceOverridingPlugin = enginePlugin.getClass().getName();
            } else if (enginePlugin.getCustomCodecService(idxSettings).isPresent()) {
                throw new IllegalStateException("existing codec service already overridden in: " + codecServiceOverridingPlugin + " attempting to override again by: " + enginePlugin.getClass().getName());
            }
            if (!translogDeletionPolicyFactory.isPresent()) {
                translogDeletionPolicyFactory = enginePlugin.getCustomTranslogDeletionPolicyFactory();
                translogDeletionPolicyOverridingPlugin = enginePlugin.getClass().getName();
            } else if (enginePlugin.getCustomTranslogDeletionPolicyFactory().isPresent()) {
                throw new IllegalStateException("existing TranslogDeletionPolicyFactory is already overridden in: " + translogDeletionPolicyOverridingPlugin + " attempting to override again by: " + enginePlugin.getClass().getName());
            }
            if (!codecServiceFactory.isPresent()) {
                codecServiceFactory = enginePlugin.getCustomCodecServiceFactory(idxSettings);
                codecServiceFactoryOverridingPlugin = enginePlugin.getClass().getName();
                continue;
            }
            if (!enginePlugin.getCustomCodecServiceFactory(idxSettings).isPresent()) continue;
            throw new IllegalStateException("existing codec service factory already overridden in: " + codecServiceFactoryOverridingPlugin + " attempting to override again by: " + enginePlugin.getClass().getName());
        }
        if (codecService.isPresent() && codecServiceFactory.isPresent()) {
            throw new IllegalStateException("both codec service and codec service factory are present, codec service provided by: " + codecServiceOverridingPlugin + " conflicts with codec service factory provided by: " + codecServiceFactoryOverridingPlugin);
        }
        CodecService instance = codecService.orElse(null);
        this.codecServiceFactory = instance != null ? config -> instance : (CodecServiceFactory)codecServiceFactory.orElse(null);
        this.translogDeletionPolicyFactory = translogDeletionPolicyFactory.orElse((idxs, rtls) -> null);
    }

    public EngineConfig newEngineConfig(ShardId shardId, ThreadPool threadPool, IndexSettings indexSettings, Engine.Warmer warmer, Store store, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> externalRefreshListener, List<ReferenceManager.RefreshListener> internalRefreshListener, Sort indexSort, CircuitBreakerService circuitBreakerService, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier, LongSupplier primaryTermSupplier, EngineConfig.TombstoneDocSupplier tombstoneDocSupplier, boolean isReadOnlyReplica) {
        CodecService codecServiceToUse = codecService;
        if (codecService == null && this.codecServiceFactory != null) {
            codecServiceToUse = this.newCodecServiceOrDefault(indexSettings, null, null, null);
        }
        return new EngineConfig(shardId, threadPool, indexSettings, warmer, store, mergePolicy, analyzer, similarity, codecServiceToUse, eventListener, queryCache, queryCachingPolicy, translogConfig, this.translogDeletionPolicyFactory, flushMergesAfter, externalRefreshListener, internalRefreshListener, indexSort, circuitBreakerService, globalCheckpointSupplier, retentionLeasesSupplier, primaryTermSupplier, tombstoneDocSupplier, isReadOnlyReplica);
    }

    public CodecService newCodecServiceOrDefault(IndexSettings indexSettings, @Nullable MapperService mapperService, Logger logger, CodecService defaultCodecService) {
        return this.codecServiceFactory != null ? this.codecServiceFactory.createCodecService(new CodecServiceConfig(indexSettings, mapperService, logger)) : defaultCodecService;
    }
}

