/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.analysis;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.easysearch.common.settings.Settings;
import org.easysearch.env.Environment;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.easysearch.index.analysis.Analysis;

public class StandardAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardAnalyzer> {
    private final StandardAnalyzer standardAnalyzer;

    public StandardAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet defaultStopwords = CharArraySet.EMPTY_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords);
        int maxTokenLength = settings.getAsInt("max_token_length", 255);
        this.standardAnalyzer = new StandardAnalyzer(stopWords);
        this.standardAnalyzer.setVersion(this.version);
        this.standardAnalyzer.setMaxTokenLength(maxTokenLength);
    }

    @Override
    public StandardAnalyzer get() {
        return this.standardAnalyzer;
    }
}

