/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.analysis;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.easysearch.common.settings.Settings;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.easysearch.index.analysis.AnalysisMode;
import org.easysearch.index.analysis.AnalyzerComponents;
import org.easysearch.index.analysis.CharFilterFactory;
import org.easysearch.index.analysis.CustomAnalyzer;
import org.easysearch.index.analysis.ReloadableCustomAnalyzer;
import org.easysearch.index.analysis.TokenFilterFactory;
import org.easysearch.index.analysis.TokenizerFactory;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final Settings analyzerSettings;
    private Analyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        this.customAnalyzer = CustomAnalyzerProvider.create(this.name(), this.analyzerSettings, tokenizers, charFilters, tokenFilters);
    }

    private static Analyzer create(String name, Settings analyzerSettings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        int positionIncrementGap = 100;
        positionIncrementGap = analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = analyzerSettings.getAsInt("offset_gap", -1);
        AnalyzerComponents components = AnalyzerComponents.createComponents(name, analyzerSettings, tokenizers, charFilters, tokenFilters);
        if (components.analysisMode().equals((Object)AnalysisMode.SEARCH_TIME)) {
            return new ReloadableCustomAnalyzer(components, positionIncrementGap, offsetGap);
        }
        return new CustomAnalyzer(components.getTokenizerFactory(), components.getCharFilters(), components.getTokenFilters(), positionIncrementGap, offsetGap);
    }

    @Override
    public Analyzer get() {
        return this.customAnalyzer;
    }
}

