/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index;

import java.io.IOException;
import java.util.Locale;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;

public enum VersionType implements Writeable
{
    INTERNAL(0){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return this.isVersionConflict(currentVersion, expectedVersion, deleted);
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (expectedVersion == -4L) {
                return "document already exists (current version [" + currentVersion + "])";
            }
            if (currentVersion == -1L) {
                return "document does not exist (expected version [" + expectedVersion + "])";
            }
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            return this.isVersionConflict(currentVersion, expectedVersion, false);
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            if (currentVersion == -1L) {
                return "document does not exist (expected version [" + expectedVersion + "])";
            }
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        private boolean isVersionConflict(long currentVersion, long expectedVersion, boolean deleted) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (expectedVersion == -4L) {
                return !deleted;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return currentVersion == -1L ? 1L : currentVersion + 1L;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version > 0L || version == -3L || version == -4L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version > 0L || version == -3L;
        }
    }
    ,
    EXTERNAL(1){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion >= expectedVersion;
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return "current version [" + currentVersion + "] is higher or equal to the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            if (currentVersion == -1L) {
                return "document does not exist (expected version [" + expectedVersion + "])";
            }
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    }
    ,
    EXTERNAL_GTE(2){

        @Override
        public boolean isVersionConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            if (currentVersion == -1L) {
                return false;
            }
            if (expectedVersion == -3L) {
                return true;
            }
            return currentVersion > expectedVersion;
        }

        @Override
        public String explainConflictForWrites(long currentVersion, long expectedVersion, boolean deleted) {
            return "current version [" + currentVersion + "] is higher than the one provided [" + expectedVersion + "]";
        }

        @Override
        public boolean isVersionConflictForReads(long currentVersion, long expectedVersion) {
            if (expectedVersion == -3L) {
                return false;
            }
            if (currentVersion == -1L) {
                return true;
            }
            return currentVersion != expectedVersion;
        }

        @Override
        public String explainConflictForReads(long currentVersion, long expectedVersion) {
            if (currentVersion == -1L) {
                return "document does not exist (expected version [" + expectedVersion + "])";
            }
            return "current version [" + currentVersion + "] is different than the one provided [" + expectedVersion + "]";
        }

        @Override
        public long updateVersion(long currentVersion, long expectedVersion) {
            return expectedVersion;
        }

        @Override
        public boolean validateVersionForWrites(long version) {
            return version >= 0L;
        }

        @Override
        public boolean validateVersionForReads(long version) {
            return version >= 0L || version == -3L;
        }
    };

    private final byte value;

    private VersionType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract boolean isVersionConflictForWrites(long var1, long var3, boolean var5);

    public abstract String explainConflictForWrites(long var1, long var3, boolean var5);

    public abstract boolean isVersionConflictForReads(long var1, long var3);

    public abstract String explainConflictForReads(long var1, long var3);

    public abstract long updateVersion(long var1, long var3);

    public abstract boolean validateVersionForWrites(long var1);

    public abstract boolean validateVersionForReads(long var1);

    public static VersionType fromString(String versionType) {
        if ("internal".equals(versionType)) {
            return INTERNAL;
        }
        if ("external".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gt".equals(versionType)) {
            return EXTERNAL;
        }
        if ("external_gte".equals(versionType)) {
            return EXTERNAL_GTE;
        }
        throw new IllegalArgumentException("No version type match [" + versionType + "]");
    }

    public static VersionType fromString(String versionType, VersionType defaultVersionType) {
        if (versionType == null) {
            return defaultVersionType;
        }
        return VersionType.fromString(versionType);
    }

    public static String toString(VersionType versionType) {
        return versionType.name().toLowerCase(Locale.ROOT);
    }

    public static VersionType fromValue(byte value) {
        if (value == 0) {
            return INTERNAL;
        }
        if (value == 1) {
            return EXTERNAL;
        }
        if (value == 2) {
            return EXTERNAL_GTE;
        }
        throw new IllegalArgumentException("No version type match [" + value + "]");
    }

    public static VersionType readFromStream(StreamInput in) throws IOException {
        return in.readEnum(VersionType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }
}

