/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.discovery;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.concurrent.ConcurrentCollections;

public class BlockingClusterStatePublishResponseHandler {
    private final CountDownLatch latch;
    private final Set<DiscoveryNode> pendingNodes = ConcurrentCollections.newConcurrentSet();
    private final Set<DiscoveryNode> failedNodes;

    public BlockingClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes) {
        this.pendingNodes.addAll(publishingToNodes);
        this.latch = new CountDownLatch(this.pendingNodes.size());
        this.failedNodes = ConcurrentCollections.newConcurrentSet();
    }

    public void onResponse(DiscoveryNode node) {
        boolean found = this.pendingNodes.remove(node);
        assert (found) : "node [" + node + "] already responded or failed";
        this.latch.countDown();
    }

    public void onFailure(DiscoveryNode node, Exception e) {
        boolean found = this.pendingNodes.remove(node);
        assert (found) : "node [" + node + "] already responded or failed";
        boolean added = this.failedNodes.add(node);
        assert (added) : "duplicate failures for " + node;
        this.latch.countDown();
    }

    public boolean awaitAllNodes(TimeValue timeout) throws InterruptedException {
        boolean success = this.latch.await(timeout.millis(), TimeUnit.MILLISECONDS);
        assert (!success || this.pendingNodes.isEmpty()) : "response count reached 0 but still waiting for some nodes";
        return success;
    }

    public DiscoveryNode[] pendingNodes() {
        return this.pendingNodes.toArray(new DiscoveryNode[0]);
    }

    public Set<DiscoveryNode> getFailedNodes() {
        return Collections.unmodifiableSet(this.failedNodes);
    }
}

