/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.util;

final class FastMath {
    private static final double ONE_DIV_F2 = 0.5;
    private static final double ONE_DIV_F3 = 0.16666666666666666;
    private static final double ONE_DIV_F4 = 0.041666666666666664;
    private static final double TWO_POW_N28 = Double.longBitsToDouble(0x3E30000000000000L);
    private static final double TWO_POW_66 = Double.longBitsToDouble(0x4410000000000000L);
    private static final double LOG_DOUBLE_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    private static final double ATAN_MAX_VALUE_FOR_TABS = StrictMath.tan(Math.toRadians(74.0));
    private static final int ATAN_TABS_SIZE = 8192;
    private static final double ATAN_DELTA = ATAN_MAX_VALUE_FOR_TABS / 8191.0;
    private static final double ATAN_INDEXER = 1.0 / ATAN_DELTA;
    private static final double[] atanTab = new double[8192];
    private static final double[] atanDer1DivF1Tab = new double[8192];
    private static final double[] atanDer2DivF2Tab = new double[8192];
    private static final double[] atanDer3DivF3Tab = new double[8192];
    private static final double[] atanDer4DivF4Tab = new double[8192];
    private static final double ATAN_HI3 = Double.longBitsToDouble(4609753056924675352L);
    private static final double ATAN_LO3 = Double.longBitsToDouble(4364452196894661639L);
    private static final double ATAN_AT0 = Double.longBitsToDouble(4599676419421066509L);
    private static final double ATAN_AT1 = Double.longBitsToDouble(-4626998257160492092L);
    private static final double ATAN_AT2 = Double.longBitsToDouble(4594314991288484863L);
    private static final double ATAN_AT3 = Double.longBitsToDouble(-4630701217362536847L);
    private static final double ATAN_AT4 = Double.longBitsToDouble(4591215095208222830L);
    private static final double ATAN_AT5 = Double.longBitsToDouble(-4633165035261879699L);
    private static final double ATAN_AT6 = Double.longBitsToDouble(4589464229703073105L);
    private static final double ATAN_AT7 = Double.longBitsToDouble(-4634804155249132134L);
    private static final double ATAN_AT8 = Double.longBitsToDouble(4587333258118041067L);
    private static final double ATAN_AT9 = Double.longBitsToDouble(-4637946461342241745L);
    private static final double ATAN_AT10 = Double.longBitsToDouble(4580351289466214929L);

    private FastMath() {
    }

    public static double sinh(double value) {
        double h;
        if (value < 0.0) {
            value = -value;
            h = -0.5;
        } else {
            h = 0.5;
        }
        if (value < 22.0) {
            if (value < TWO_POW_N28) {
                return h < 0.0 ? -value : value;
            }
            double t = Math.expm1(value);
            return h * (t + t / (t + 1.0));
        }
        if (value < LOG_DOUBLE_MAX_VALUE) {
            return h * Math.exp(value);
        }
        double t = Math.exp(value * 0.5);
        return h * t * t;
    }

    public static double atan(double value) {
        boolean negateResult;
        if (value < 0.0) {
            value = -value;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (value == 1.0) {
            return negateResult ? -0.7853981633974483 : 0.7853981633974483;
        }
        if (value <= ATAN_MAX_VALUE_FOR_TABS) {
            int index = (int)(value * ATAN_INDEXER + 0.5);
            double delta = value - (double)index * ATAN_DELTA;
            double result = atanTab[index] + delta * (atanDer1DivF1Tab[index] + delta * (atanDer2DivF2Tab[index] + delta * (atanDer3DivF3Tab[index] + delta * atanDer4DivF4Tab[index])));
            return negateResult ? -result : result;
        }
        if (value < TWO_POW_66) {
            double x = -1.0 / value;
            double x2 = x * x;
            double x4 = x2 * x2;
            double s1 = x2 * (ATAN_AT0 + x4 * (ATAN_AT2 + x4 * (ATAN_AT4 + x4 * (ATAN_AT6 + x4 * (ATAN_AT8 + x4 * ATAN_AT10)))));
            double s2 = x4 * (ATAN_AT1 + x4 * (ATAN_AT3 + x4 * (ATAN_AT5 + x4 * (ATAN_AT7 + x4 * ATAN_AT9))));
            double result = ATAN_HI3 - (x * (s1 + s2) - ATAN_LO3 - x);
            return negateResult ? -result : result;
        }
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        return negateResult ? -1.5707963267948966 : 1.5707963267948966;
    }

    static {
        for (int i = 0; i < 8192; ++i) {
            double x = (double)i * ATAN_DELTA;
            double onePlusXSqInv = 1.0 / (1.0 + x * x);
            double onePlusXSqInv2 = onePlusXSqInv * onePlusXSqInv;
            double onePlusXSqInv3 = onePlusXSqInv2 * onePlusXSqInv;
            double onePlusXSqInv4 = onePlusXSqInv2 * onePlusXSqInv2;
            FastMath.atanTab[i] = StrictMath.atan(x);
            FastMath.atanDer1DivF1Tab[i] = onePlusXSqInv;
            FastMath.atanDer2DivF2Tab[i] = -2.0 * x * onePlusXSqInv2 * 0.5;
            FastMath.atanDer3DivF3Tab[i] = (-2.0 + 6.0 * x * x) * onePlusXSqInv3 * 0.16666666666666666;
            FastMath.atanDer4DivF4Tab[i] = 24.0 * x * (1.0 - x * x) * onePlusXSqInv4 * 0.041666666666666664;
        }
    }
}

