/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.time;

class DateUtilsRounding {
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final long MILLIS_PER_YEAR = 31556952000L;
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY;
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY;
    private static final long AVERAGE_MILLIS_PER_YEAR_DIVIDED_BY_TWO = 15778476000L;
    private static final long APPROX_MILLIS_AT_EPOCH_DIVIDED_BY_TWO = 31083597720000L;

    DateUtilsRounding() {
    }

    static long utcMillisAtStartOfYear(int year) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (DateUtilsRounding.isLeapYear(year)) {
                --leapYears;
            }
        }
        return ((long)year * 365L + (long)(leapYears - 719527)) * 86400000L;
    }

    static boolean isLeapYear(int year) {
        if ((year & 3) != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return (year / 100 & 3) == 0;
    }

    static int getYear(long utcMillis) {
        long oneYear;
        int year;
        long yearStart;
        long diff;
        long unitMillis = 15778476000L;
        long i2 = (utcMillis >> 1) + 31083597720000L;
        if (i2 < 0L) {
            i2 = i2 - unitMillis + 1L;
        }
        if ((diff = utcMillis - (yearStart = DateUtilsRounding.utcMillisAtStartOfYear(year = (int)(i2 / unitMillis)))) < 0L) {
            --year;
        } else if (diff >= 31536000000L && (yearStart += (oneYear = DateUtilsRounding.isLeapYear(year) ? 31622400000L : 31536000000L)) <= utcMillis) {
            ++year;
        }
        return year;
    }

    static int getMonthOfYear(long utcMillis, int year) {
        int i = (int)(utcMillis - DateUtilsRounding.utcMillisAtStartOfYear(year) >> 10);
        return DateUtilsRounding.isLeapYear(year) ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    static long getTotalMillisByYearMonth(int year, int month) {
        if (DateUtilsRounding.isLeapYear(year)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
    }

    static {
        MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        long minSum = 0L;
        long maxSum = 0L;
        for (int i = 0; i < 11; ++i) {
            long millis = (long)MIN_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            DateUtilsRounding.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i + 1] = minSum += millis;
            millis = (long)MAX_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            DateUtilsRounding.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i + 1] = maxSum += millis;
        }
    }
}

