/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;

public abstract class NetworkUtils {
    @Deprecated
    static final boolean PREFER_V6 = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses", "false"));
    @Deprecated
    public static final boolean SUPPORTS_V6;

    private NetworkUtils() {
    }

    static int sortKey(InetAddress address, boolean prefer_v6) {
        int key = address.getAddress().length;
        if (prefer_v6) {
            key = -key;
        }
        if (address.isAnyLocalAddress()) {
            key += 5;
        }
        if (address.isMulticastAddress()) {
            key += 4;
        }
        if (address.isLoopbackAddress()) {
            key += 3;
        }
        if (address.isLinkLocalAddress()) {
            key += 2;
        }
        if (address.isSiteLocalAddress()) {
            ++key;
        }
        return key;
    }

    @Deprecated
    public static void sortAddresses(List<InetAddress> list) {
        Collections.sort(list, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress left, InetAddress right) {
                int cmp = Integer.compare(NetworkUtils.sortKey(left, PREFER_V6), NetworkUtils.sortKey(right, PREFER_V6));
                if (cmp == 0) {
                    cmp = new BytesRef(left.getAddress()).compareTo(new BytesRef(right.getAddress()));
                }
                return cmp;
            }
        });
    }

    static List<NetworkInterface> getInterfaces() throws SocketException {
        ArrayList<NetworkInterface> all = new ArrayList<NetworkInterface>();
        NetworkUtils.addAllInterfaces(all, Collections.list(NetworkInterface.getNetworkInterfaces()));
        Collections.sort(all, new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface left, NetworkInterface right) {
                return Integer.compare(left.getIndex(), right.getIndex());
            }
        });
        return all;
    }

    private static void addAllInterfaces(List<NetworkInterface> target, List<NetworkInterface> level) {
        if (!level.isEmpty()) {
            target.addAll(level);
            for (NetworkInterface intf : level) {
                NetworkUtils.addAllInterfaces(target, Collections.list(intf.getSubInterfaces()));
            }
        }
    }

    public static boolean defaultReuseAddress() {
        return !Constants.WINDOWS;
    }

    private static InetAddress[] filterAllAddresses(Predicate<InetAddress> predicate, String message) throws IOException {
        List<NetworkInterface> interfaces = NetworkUtils.getInterfaces();
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (NetworkInterface intf : interfaces) {
            for (InetAddress address : Collections.list(intf.getInetAddresses())) {
                if (!predicate.test(address) || !NetworkUtils.isUp(intf)) continue;
                list.add(address);
            }
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException(message + ", got " + interfaces);
        }
        return list.toArray(new InetAddress[0]);
    }

    private static boolean isUp(NetworkInterface intf) throws IOException {
        try {
            return intf.isUp();
        }
        catch (SocketException e) {
            if (intf.getName().startsWith("veth") && e.getMessage().equals("No such device (getFlags() failed)")) {
                return false;
            }
            throw new IOException("failed to check if interface [" + intf.getName() + "] is up", e);
        }
    }

    static InetAddress[] getLoopbackAddresses() throws IOException {
        return NetworkUtils.filterAllAddresses(InetAddress::isLoopbackAddress, "no up-and-running loopback addresses found");
    }

    static InetAddress[] getSiteLocalAddresses() throws IOException {
        return NetworkUtils.filterAllAddresses(InetAddress::isSiteLocalAddress, "No up-and-running site-local (private) addresses found");
    }

    static InetAddress[] getGlobalAddresses() throws IOException {
        return NetworkUtils.filterAllAddresses(address -> !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress(), "no up-and-running global-scope (public) addresses found");
    }

    static InetAddress[] getAllAddresses() throws IOException {
        return NetworkUtils.filterAllAddresses(address -> true, "no up-and-running addresses found");
    }

    static Optional<NetworkInterface> maybeGetInterfaceByName(List<NetworkInterface> networkInterfaces, String name) {
        return networkInterfaces.stream().filter(netIf -> name.equals(netIf.getName())).findFirst();
    }

    static InetAddress[] getAddressesForInterface(String name) throws SocketException {
        Optional<NetworkInterface> networkInterface = NetworkUtils.maybeGetInterfaceByName(NetworkUtils.getInterfaces(), name);
        if (!networkInterface.isPresent()) {
            throw new IllegalArgumentException("No interface named '" + name + "' found, got " + NetworkUtils.getInterfaces());
        }
        if (!networkInterface.get().isUp()) {
            throw new IllegalArgumentException("Interface '" + name + "' is not up and running");
        }
        ArrayList<InetAddress> list = Collections.list(networkInterface.get().getInetAddresses());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Interface '" + name + "' has no internet addresses");
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] filterIPV4(InetAddress[] addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv4 addresses found in " + Arrays.toString(addresses));
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    static InetAddress[] filterIPV6(InetAddress[] addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet6Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv6 addresses found in " + Arrays.toString(addresses));
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    static {
        boolean v = false;
        try {
            block2: for (NetworkInterface nic : NetworkUtils.getInterfaces()) {
                for (InetAddress address : Collections.list(nic.getInetAddresses())) {
                    if (!(address instanceof Inet6Address)) continue;
                    v = true;
                    continue block2;
                }
            }
        }
        catch (SecurityException | SocketException misconfiguration) {
            v = true;
        }
        SUPPORTS_V6 = v;
    }
}

