/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.easysearch.common.inject.Binding;
import org.easysearch.common.inject.Injector;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.Scope;
import org.easysearch.common.inject.State;
import org.easysearch.common.inject.TypeLiteral;
import org.easysearch.common.inject.WeakKeySet;
import org.easysearch.common.inject.internal.BindingImpl;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.internal.InstanceBindingImpl;
import org.easysearch.common.inject.internal.InternalFactory;
import org.easysearch.common.inject.internal.MatcherAndConverter;
import org.easysearch.common.inject.internal.SourceProvider;
import org.easysearch.common.inject.spi.TypeListenerBinding;

class InheritingState
implements State {
    private final State parent;
    private final Map<Key<?>, Binding<?>> explicitBindingsMutable = new LinkedHashMap();
    private final Map<Key<?>, Binding<?>> explicitBindings = Collections.unmodifiableMap(this.explicitBindingsMutable);
    private final Map<Class<? extends Annotation>, Scope> scopes = new HashMap<Class<? extends Annotation>, Scope>();
    private final List<MatcherAndConverter> converters = new ArrayList<MatcherAndConverter>();
    private final List<TypeListenerBinding> listenerBindings = new ArrayList<TypeListenerBinding>();
    private WeakKeySet blacklistedKeys = new WeakKeySet();
    private final Object lock;

    InheritingState(State parent) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.lock = parent == State.NONE ? this : parent.lock();
    }

    @Override
    public State parent() {
        return this.parent;
    }

    @Override
    public <T> BindingImpl<T> getExplicitBinding(Key<T> key) {
        Binding<?> binding = this.explicitBindings.get(key);
        return binding != null ? (BindingImpl<T>)binding : this.parent.getExplicitBinding(key);
    }

    @Override
    public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
        return this.explicitBindings;
    }

    @Override
    public void putBinding(Key<?> key, BindingImpl<?> binding) {
        this.explicitBindingsMutable.put(key, binding);
    }

    @Override
    public Scope getScope(Class<? extends Annotation> annotationType) {
        Scope scope = this.scopes.get(annotationType);
        return scope != null ? scope : this.parent.getScope(annotationType);
    }

    @Override
    public void putAnnotation(Class<? extends Annotation> annotationType, Scope scope) {
        this.scopes.put(annotationType, scope);
    }

    @Override
    public Iterable<MatcherAndConverter> getConvertersThisLevel() {
        return this.converters;
    }

    @Override
    public void addConverter(MatcherAndConverter matcherAndConverter) {
        this.converters.add(matcherAndConverter);
    }

    @Override
    public MatcherAndConverter getConverter(String stringValue, TypeLiteral<?> type, Errors errors, Object source) {
        MatcherAndConverter matchingConverter = null;
        for (State s = this; s != State.NONE; s = s.parent()) {
            for (MatcherAndConverter converter : s.getConvertersThisLevel()) {
                if (!converter.getTypeMatcher().matches(type)) continue;
                if (matchingConverter != null) {
                    errors.ambiguousTypeConversion(stringValue, source, type, matchingConverter, converter);
                }
                matchingConverter = converter;
            }
        }
        return matchingConverter;
    }

    @Override
    public void addTypeListener(TypeListenerBinding listenerBinding) {
        this.listenerBindings.add(listenerBinding);
    }

    @Override
    public List<TypeListenerBinding> getTypeListenerBindings() {
        List<TypeListenerBinding> parentBindings = this.parent.getTypeListenerBindings();
        ArrayList<TypeListenerBinding> result = new ArrayList<TypeListenerBinding>(parentBindings.size() + 1);
        result.addAll(parentBindings);
        result.addAll(this.listenerBindings);
        return result;
    }

    @Override
    public void blacklist(Key<?> key) {
        this.parent.blacklist(key);
        this.blacklistedKeys.add(key);
    }

    @Override
    public boolean isBlacklisted(Key<?> key) {
        return this.blacklistedKeys.contains(key);
    }

    @Override
    public void clearBlacklisted() {
        this.blacklistedKeys = new WeakKeySet();
    }

    @Override
    public void makeAllBindingsToEagerSingletons(Injector injector) {
        LinkedHashMap x = new LinkedHashMap();
        for (Map.Entry<Key<?>, Binding<?>> entry : this.explicitBindingsMutable.entrySet()) {
            Key<?> key = entry.getKey();
            BindingImpl binding = (BindingImpl)entry.getValue();
            Object value = binding.getProvider().get();
            x.put(key, new InstanceBindingImpl(injector, key, SourceProvider.UNKNOWN_SOURCE, new InternalFactory.Instance(value), Collections.emptySet(), value));
        }
        this.explicitBindingsMutable.clear();
        this.explicitBindingsMutable.putAll(x);
    }

    @Override
    public Object lock() {
        return this.lock;
    }
}

